/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.editor.embedded;

import com.datastax.devcenter.cql.ui.editor.embedded.EmbeddedCqlEditorValidationIssueProcessor;
import java.util.List;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.xtext.validation.Issue;

public class EmbeddedCqlEditorValidationStatusProvider
extends MultiValidator {
    private final EmbeddedCqlEditorValidationIssueProcessor validationStatus;

    public EmbeddedCqlEditorValidationStatusProvider(EmbeddedCqlEditorValidationIssueProcessor validationStatus) {
        this.validationStatus = validationStatus;
    }

    protected IStatus validate() {
        IStatus status = Status.OK_STATUS;
        List<Issue> issues = this.validationStatus.getIssues();
        if (issues != null) {
            for (Issue issue : issues) {
                int severity = this.getIssueSeverity(issue);
                if (severity <= status.getSeverity()) continue;
                status = new Status(severity, "com.datastax.devcenter.cql.ui.CqlActivator", issue.getMessage());
            }
        }
        return status;
    }

    private int getIssueSeverity(Issue issue) {
        switch (issue.getSeverity()) {
            case ERROR: {
                return 4;
            }
            case WARNING: {
                return 2;
            }
            case INFO: {
                return 1;
            }
        }
        return 0;
    }
}

