/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.editor.embedded;

import com.datastax.devcenter.cql.ui.CqlActivator;
import com.datastax.devcenter.cql.ui.editor.folding.DevCenterFoldingStructureProvider;
import com.datastax.devcenter.json.ui.editor.embedded.EmbeddedJsonEditorResourceProvider;
import com.datastax.devcenter.json.ui.util.JsonUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.validation.IResourceValidator;

public class EmbeddedJsonViewer {
    @Inject
    private DevCenterFoldingStructureProvider foldingStructureProvider;
    @Inject
    private EmbeddedEditorFactory factory;
    @Inject
    private IResourceValidator validator;
    private IEditedResourceProvider resourceProvider;
    private Composite parent;
    private ProjectionViewer viewer;
    private EmbeddedEditor editor;
    private String jsonContent;
    private EmbeddedEditorModelAccess modelAccess;
    private static final String NEWLINE = System.getProperty("line.separator") != null ? System.getProperty("line.separator") : "\n";

    public static EmbeddedJsonViewer buildJsonViewer(List<String> jsonStrings, int numberOfTopLevelFieldsBeforeLineBreak, Composite parent) {
        Injector injector = CqlActivator.getDefault().getInjector("com.datastax.devcenter.json.Json");
        EmbeddedJsonViewer embeddedJsonViewer = new EmbeddedJsonViewer(jsonStrings, numberOfTopLevelFieldsBeforeLineBreak, parent);
        embeddedJsonViewer.resourceProvider = (IEditedResourceProvider)injector.getInstance(EmbeddedJsonEditorResourceProvider.class);
        injector.injectMembers((Object)embeddedJsonViewer);
        embeddedJsonViewer.createEditor();
        return embeddedJsonViewer;
    }

    public synchronized void renderView() {
        if (this.modelAccess == null) {
            this.modelAccess = this.editor.createPartialEditor("", this.jsonContent, "", false);
        }
        this.toggle();
        this.collapseResults();
    }

    public void collapseResults() {
        this.viewer.doOperation(21);
    }

    public void expandAll() {
        this.viewer.doOperation(20);
    }

    private void toggle() {
        this.viewer.doOperation(19);
    }

    public void setContent(List<String> jsonStrings, int numberOfTopLevelFieldsBeforeLineBreak) {
        this.jsonContent = String.valueOf(this.formatJsonForCodeFolding(jsonStrings, numberOfTopLevelFieldsBeforeLineBreak)) + NEWLINE;
        this.modelAccess.updateModel("", this.jsonContent, "");
        this.toggle();
    }

    private String formatJsonForCodeFolding(List<String> jsonStrings, final int numberOfTopLevelFieldsBeforeLineBreak) {
        if (jsonStrings == null || jsonStrings.isEmpty()) {
            return "";
        }
        jsonStrings = Lists.transform(jsonStrings, (Function)new Function<String, String>(){

            public String apply(String unformattedJson) {
                try {
                    return JsonUtil.formatJsonForCodeFolding(unformattedJson, numberOfTopLevelFieldsBeforeLineBreak);
                }
                catch (Exception exception) {
                    return unformattedJson;
                }
            }
        });
        return StringUtils.join((Collection)jsonStrings, (String)"\n");
    }

    private void createEditor() {
        this.editor = this.factory.newEditor(this.resourceProvider).readOnly().showErrorAndWarningAnnotations().withResourceValidator(this.validator).withParent(this.parent);
        this.viewer = this.editor.getViewer();
        this.viewer.getTextWidget().setFont(JFaceResources.getTextFont());
        ProjectionSupport projectionSupport = new ProjectionSupport(this.viewer, this.createAnnotationAccess(), this.getSharedColors());
        projectionSupport.install();
        this.foldingStructureProvider.install(this.editor, (ProjectionViewer)this.editor.getViewer());
    }

    private EmbeddedJsonViewer(List<String> jsonStrings, int numberOfTopLevelFieldsBeforeLineBreak, Composite parent) {
        this.jsonContent = String.valueOf(this.formatJsonForCodeFolding(jsonStrings, numberOfTopLevelFieldsBeforeLineBreak)) + NEWLINE;
        this.parent = parent;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess(){

            public int getLayer(Annotation annotation) {
                if (annotation.isMarkedDeleted()) {
                    return 0;
                }
                return super.getLayer(annotation);
            }
        };
    }

    protected ISharedTextColors getSharedColors() {
        return EditorsPlugin.getDefault().getSharedTextColors();
    }
}

