/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.editor.toolbar;

import com.datastax.devcenter.common.ui.customizations.ComboFactory;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.models.ConnectionList;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.cql.ui.editor.toolbar.CqlEditorToolbarModel;
import com.datastax.devcenter.cql.ui.editor.toolbar.viewers.ConnectionComboViewer;
import com.datastax.devcenter.cql.ui.editor.toolbar.viewers.KeyspaceComboViewer;
import com.ibm.icu.text.NumberFormat;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.menus.IMenuService;

public class CqlEditorToolbar
extends Composite
implements ConnectionList.Listener {
    private final CqlEditorToolbarModel model = new CqlEditorToolbarModel();
    private final CqlEditorPart editor;
    private KeyspaceComboViewer keyspaceComboViewer;
    private ConnectionComboViewer connectionComboViewer;
    private Text rowLimitText;
    private ToolBarManager toolBarManager;
    private AggregateValidationStatus globalValidationStatus;

    public CqlEditorToolbar(Composite parent, CqlEditorPart editor) {
        super(parent, 0);
        this.editor = editor;
        RowLayout layout = new RowLayout();
        layout.center = true;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        this.setLayout((Layout)layout);
        this.createConnectionSelector();
        this.createKeyspaceSelector();
        this.createLimitSelector();
        this.createExecuteScriptButton();
        DataBindingContext ctx = new DataBindingContext();
        this.bindConnection(ctx);
        this.bindKeyspace(ctx);
        this.bindRowLimit(ctx);
        this.bindExecuteScriptButton(ctx);
        ctx.updateTargets();
        ConnectionList.getInstance().addListener((ConnectionList.Listener)this);
    }

    public void init() {
        this.connectionComboViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConnectionList.getInstance().fireConnectionsListChanged();
            }
        });
        this.keyspaceComboViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!CqlEditorToolbar.this.isDisposed()) {
                            CqlEditorToolbar.this.editor.updateDefaultKeyspace(CqlEditorToolbar.this.model.getKeyspace());
                            CqlEditorToolbar.this.editor.updateConnectionAndRevalidate(CqlEditorToolbar.this.model.getConnection());
                        }
                    }
                });
            }
        });
        this.connectionListUpdated();
    }

    public void connectionListUpdated() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!CqlEditorToolbar.this.isDisposed()) {
                    CqlEditorToolbar.this.connectionComboViewer.refresh();
                    CqlEditorToolbar.this.keyspaceComboViewer.refresh(CqlEditorToolbar.this.model.getConnection());
                    CqlEditorToolbar.this.editor.updateDefaultKeyspace(CqlEditorToolbar.this.model.getKeyspace());
                    CqlEditorToolbar.this.editor.updateConnectionAndRevalidate(CqlEditorToolbar.this.model.getConnection());
                }
            }
        });
    }

    public IStatus getValidationStatus() {
        IStatus status = (IStatus)this.globalValidationStatus.getValue();
        return status;
    }

    public void dispose() {
        super.dispose();
        if (this.globalValidationStatus != null) {
            this.globalValidationStatus.dispose();
        }
        ConnectionList.getInstance().removeListener((ConnectionList.Listener)this);
    }

    public void setEnableExecuteCqlScript(boolean enabled) {
        this.toolBarManager.getControl().getItems()[0].setEnabled(enabled);
    }

    public void setExecuteCqlScriptTooltip() {
        String tooltip = this.toolBarManager.getControl().getItems()[0].getToolTipText();
        String keyboardShortcut = "";
        if (tooltip.indexOf(40) > -1) {
            keyboardShortcut = tooltip.substring(tooltip.indexOf(40));
        }
        this.toolBarManager.getControl().getItems()[0].setToolTipText("Execute CQL Script " + keyboardShortcut);
    }

    public void setExecuteSelectedStatementTooltip() {
        String tooltip = this.toolBarManager.getControl().getItems()[0].getToolTipText();
        String keyboardShortcut = "";
        if (tooltip.indexOf(40) > -1) {
            keyboardShortcut = tooltip.substring(tooltip.indexOf(40));
        }
        this.toolBarManager.getControl().getItems()[0].setToolTipText("Execute Selected CQL Statements " + keyboardShortcut);
    }

    public Connection getSelectedConnection() {
        return this.model.getConnection();
    }

    public void setSelectedConnection(Connection connection) {
        this.connectionComboViewer.setSelection((ISelection)new StructuredSelection((Object)connection));
    }

    public String getSelectedKeyspace() {
        return this.model.getKeyspace();
    }

    public int getRowLimit() {
        return this.model.getRowLimit();
    }

    private void createConnectionSelector() {
        Composite group = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        new Label(group, 0).setText("Run using connection:");
        Composite combo = ComboFactory.createCombo((Composite)group, (int)8);
        GridData data = new GridData(16384, 4, true, true);
        data.widthHint = 150;
        combo.setLayoutData((Object)data);
        this.connectionComboViewer = combo instanceof Combo ? new ConnectionComboViewer((Combo)combo) : new ConnectionComboViewer((CCombo)combo);
        if (Util.isGtk()) {
            this.connectionComboViewer.add("connection1");
            data.heightHint = this.connectionComboViewer.getControl().computeSize((int)-1, (int)-1).y;
            this.connectionComboViewer.remove("connection1");
        }
    }

    private void createKeyspaceSelector() {
        Composite group = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        new Label(group, 0).setText("in keyspace:");
        Composite combo = ComboFactory.createCombo((Composite)group, (int)8);
        GridData data = new GridData(16384, 4, true, true);
        data.widthHint = 150;
        combo.setLayoutData((Object)data);
        this.keyspaceComboViewer = combo instanceof Combo ? new KeyspaceComboViewer((Combo)combo) : new KeyspaceComboViewer((CCombo)combo);
        if (Util.isGtk()) {
            this.keyspaceComboViewer.add("keyspace1");
            data.heightHint = this.keyspaceComboViewer.getControl().computeSize((int)-1, (int)-1).y;
            this.keyspaceComboViewer.remove("keyspace1");
        }
    }

    private void createLimitSelector() {
        Composite group = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        new Label(group, 0).setText("with limit:");
        this.rowLimitText = new Text(group, 2048);
        GridData data = new GridData(50, -1);
        data.horizontalIndent = 5;
        this.rowLimitText.setLayoutData((Object)data);
    }

    private void createExecuteScriptButton() {
        this.toolBarManager = new ToolBarManager(0x800000);
        this.toolBarManager.createControl((Composite)this);
        IMenuService menuService = (IMenuService)this.editor.getSite().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)this.toolBarManager, "toolbar:com.datastax.devcenter.cql.ui.editor.toolbar.CqlEditorToolbar");
        this.toolBarManager.update(true);
    }

    private void bindConnection(DataBindingContext ctx) {
        IViewerObservableValue targetObservable = ViewersObservables.observeSingleSelection((Viewer)this.connectionComboViewer);
        final IObservableValue modelObservable = PojoObservables.observeValue((Object)this.model, (String)"connection");
        ctx.bindValue((IObservableValue)targetObservable, modelObservable);
        MultiValidator validator = new MultiValidator(){

            protected IStatus validate() {
                Connection connection = (Connection)modelObservable.getValue();
                if (connection == null) {
                    return ValidationStatus.error((String)"Connection cannot be empty");
                }
                return ValidationStatus.ok();
            }
        };
        ctx.addValidationStatusProvider((ValidationStatusProvider)validator);
    }

    private void bindKeyspace(DataBindingContext ctx) {
        IViewerObservableValue targetObservable = ViewersObservables.observeSingleSelection((Viewer)this.keyspaceComboViewer);
        IObservableValue modelObservable = PojoObservables.observeValue((Object)this.model, (String)"keyspace");
        ctx.bindValue((IObservableValue)targetObservable, modelObservable);
    }

    private void bindRowLimit(DataBindingContext ctx) {
        ISWTObservableValue targetObservable = WidgetProperties.text((int)24).observe((Widget)this.rowLimitText);
        IObservableValue modelObservable = PojoObservables.observeValue((Object)this.model, (String)"rowLimit");
        IValidator validator = new IValidator(){

            public IStatus validate(Object value) {
                int rowLimit;
                if (value == null || value.toString().isEmpty()) {
                    return ValidationStatus.error((String)"Row limit cannot be empty");
                }
                try {
                    rowLimit = Integer.parseInt(value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    return ValidationStatus.error((String)"Row limit must be an integer");
                }
                if (rowLimit < 1 || rowLimit > 1000) {
                    return ValidationStatus.error((String)"Row limit must be comprised between 1 and 1000");
                }
                return ValidationStatus.ok();
            }
        };
        UpdateValueStrategy targetToModelStrategy = new UpdateValueStrategy();
        targetToModelStrategy.setAfterGetValidator(validator);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        UpdateValueStrategy modelToTargetStrategy = new UpdateValueStrategy();
        modelToTargetStrategy.setConverter((IConverter)NumberToStringConverter.fromInteger((NumberFormat)numberFormat, (boolean)false));
        Binding bindValue = ctx.bindValue((IObservableValue)targetObservable, modelObservable, targetToModelStrategy, modelToTargetStrategy);
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
    }

    private void bindExecuteScriptButton(DataBindingContext ctx) {
        this.globalValidationStatus = new AggregateValidationStatus((IObservableCollection)ctx.getValidationStatusProviders(), 2);
        this.globalValidationStatus.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                CqlEditorToolbar.this.setEnableExecuteCqlScript(CqlEditorToolbar.this.getValidationStatus().isOK());
            }
        });
    }
}

