/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.editor.toolbar.viewers;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Combo;

public class KeyspaceComboViewer
extends ComboViewer {
    private final Set<String> keyspaceList = new TreeSet<String>();

    public KeyspaceComboViewer(Combo clusterCombo) {
        super(clusterCombo);
        this.init();
    }

    public KeyspaceComboViewer(CCombo clusterCCombo) {
        super(clusterCCombo);
        this.init();
    }

    private void init() {
        this.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.setInput(this.keyspaceList);
    }

    public void refresh(Connection connection) {
        Metadata metadata;
        this.keyspaceList.clear();
        Metadata metadata2 = metadata = connection == null ? null : connection.getMetadata();
        if (metadata != null) {
            this.keyspaceList.addAll(Lists.transform((List)metadata.getKeyspaces(), (Function)new Function<KeyspaceMetadata, String>(){

                public String apply(KeyspaceMetadata input) {
                    return input.getName();
                }
            }));
        }
        this.refresh();
    }
}

