/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.handlers;

import com.datastax.devcenter.common.metrics.Metrics;
import com.datastax.devcenter.cql.ui.handlers.AbstractScriptHandler;
import com.datastax.devcenter.cql.ui.views.CqlScriptsViewPart;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteCqlScriptHandler
extends AbstractScriptHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage page = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (this.confirmDelete(selection)) {
            for (IFile file : selection) {
                this.delete(file);
            }
            CqlScriptsViewPart part = (CqlScriptsViewPart)HandlerUtil.getActivePart((ExecutionEvent)event);
            part.notifyScriptListChanged();
        }
        this.logOpenFileStats(page);
        return null;
    }

    private boolean confirmDelete(IStructuredSelection selection) {
        if (selection.size() == 1) {
            IFile file = (IFile)selection.getFirstElement();
            return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Delete CQL Script", (String)("Are you sure you want to delete CQL script: " + file.getName() + "?"));
        }
        return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Delete CQL Script", (String)"Are you sure you want to delete the selected CQL scripts?");
    }

    private void delete(IFile file) throws ExecutionException {
        try {
            file.delete(true, null);
            Metrics.incrementCounter((String)"delete_file_count");
        }
        catch (CoreException e) {
            throw new ExecutionException("Error deleting CQL script: " + file, (Throwable)e);
        }
    }
}

