/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.handlers;

import com.datastax.devcenter.common.metrics.Metrics;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.TypoStatement;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.cql.ui.jobs.AbstractCqlResultsWorkspaceJob;
import com.datastax.devcenter.cql.ui.jobs.ExecuteCqlScriptJobChangeAdapter;
import com.datastax.devcenter.cql.ui.jobs.ExecuteCqlScriptMetadataWorkspaceJob;
import com.datastax.devcenter.cql.ui.jobs.ExecuteCqlScriptWorkspaceJob;
import com.datastax.devcenter.cql.ui.jobs.MetadataSelectStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.google.common.base.Joiner;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;

public class ExecuteCqlScriptHandler
extends AbstractHandler {
    public static final String ID = "com.datastax.devcenter.cql.ui.actions.ExecuteCqlScriptAction";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CqlEditorPart editor = (CqlEditorPart)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        String commandParameterCL = event.getParameter("com.datastax.devcenter.cql.ui.commandParameterCL");
        ConsistencyLevel consistencyLevel = StringUtils.isEmpty((String)commandParameterCL) ? ConsistencyLevel.ONE : ConsistencyLevel.valueOf((String)commandParameterCL);
        Connection connection = editor.getConnection();
        List<CqlStatement> cqlStatements = editor.getStatementList();
        if (connection != null && cqlStatements.size() > 0) {
            List<INode> errors = editor.getSyntaxErrors(cqlStatements);
            if (!errors.isEmpty()) {
                Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                MultiStatus status = this.createErrorStatus(errors);
                ErrorDialog.openError((Shell)shell, (String)"Execute CQL Script", (String)"The current CQL script cannot be executed.", (IStatus)status);
                return null;
            }
            String keyspace = editor.getSelectedKeyspace();
            CqlStatement lastStatement = cqlStatements.get(cqlStatements.size() - 1);
            AbstractCqlResultsWorkspaceJob job = null;
            if (MetadataSelectStatement.shouldRequestMetadata(lastStatement)) {
                MetadataSelectStatement metadataSelect = new MetadataSelectStatement(editor, (SelectStatement)lastStatement);
                job = new ExecuteCqlScriptMetadataWorkspaceJob(connection, cqlStatements, metadataSelect, keyspace, editor, consistencyLevel);
            } else {
                job = new ExecuteCqlScriptWorkspaceJob(connection, cqlStatements, keyspace, editor, consistencyLevel);
            }
            job.addJobChangeListener((IJobChangeListener)new ExecuteCqlScriptJobChangeAdapter(Display.getCurrent(), editor));
            editor.getCqlStatusCompositeProgressMonitor().activateProgressBar();
            editor.setEnableExecuteCqlScript(false);
            job.schedule();
            Metrics.incrementCounter((String)"execute_count");
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        if (evaluationContext == null || !(evaluationContext instanceof IEvaluationContext)) {
            return;
        }
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        Object activeEditor = context.getVariable("activeEditor");
        if (activeEditor == null || !(activeEditor instanceof CqlEditorPart)) {
            return;
        }
        CqlEditorPart editor = (CqlEditorPart)((Object)activeEditor);
        this.setBaseEnabled(editor.canExecuteCqlScript());
    }

    private MultiStatus createErrorStatus(List<INode> errors) {
        String reason = errors.size() == 1 ? "There is one syntax error in the current script (see details below).\nPlease fix it and try again." : "There are " + errors.size() + " syntax errors in the current script (see details below).\nPlease fix them and try again.";
        MultiStatus multiStatus = new MultiStatus("com.datastax.devcenter.cql.ui.CqlActivator", 1, reason, null);
        for (INode error : errors) {
            String message = this.createErrorMessage(error);
            Status subStatus = new Status(4, "com.datastax.devcenter.cql.ui.CqlActivator", message);
            multiStatus.add((IStatus)subStatus);
        }
        return multiStatus;
    }

    private String createErrorMessage(INode error) {
        EList tokens;
        EObject model;
        SyntaxErrorMessage sem = error.getSyntaxErrorMessage();
        String errorMessage = sem == null ? ((model = error.getSemanticElement()) != null && model instanceof TypoStatement ? ((tokens = ((TypoStatement)model).getTypos()).size() == 1 ? "Invalid token: " + (String)tokens.get(0) : "Invalid tokens: " + Joiner.on((String)", ").join((Iterable)tokens)) : "Invalid token") : sem.getMessage();
        String message = String.format("Line %d: %s", error.getStartLine(), errorMessage);
        return message;
    }
}

