/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.handlers.ddl;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.ui.jobs.ConnectionJobHelper;
import com.datastax.devcenter.cql.ui.utils.StructuredSelectionUtils;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.ISchemaElement;
import com.datastax.devcenter.schema.Keyspace;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbench;

public class DropSchemaElementJob
implements IRunnableWithProgress {
    private final StructuredSelection structuredSelection;
    private final Keyspace keyspace;
    private final Connection connection;
    private IStatus status = Status.CANCEL_STATUS;
    private final String dropElementKeyword;

    public DropSchemaElementJob(IWorkbench workbench, StructuredSelection structuredSelection, String dropElementKeyword) {
        this.structuredSelection = structuredSelection;
        this.keyspace = StructuredSelectionUtils.getActiveKeyspace(workbench, (IStructuredSelection)structuredSelection);
        this.connection = StructuredSelectionUtils.getActiveConnection(workbench, (IStructuredSelection)structuredSelection);
        this.dropElementKeyword = dropElementKeyword.toUpperCase();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DropSchemaElementJob.this.dropSelection();
                return null;
            }
        };
        monitor.beginTask(this.getTaskName(), -1);
        ConnectionJobHelper asyncJobHelper = new ConnectionJobHelper();
        this.status = asyncJobHelper.runCancellable((Callable)task, monitor);
    }

    private String getTaskName() {
        ISchemaElement firstElement = (ISchemaElement)this.structuredSelection.getFirstElement();
        String elementType = firstElement.getClass().getSimpleName();
        if (this.structuredSelection.size() == 1) {
            return String.format("Dropping %s %s", elementType, this.getElementName(firstElement));
        }
        return String.format("Dropping the selected %ss", elementType);
    }

    public IStatus getStatus() {
        return this.status;
    }

    private void dropSelection() throws Exception {
        ArrayList<String> statements = new ArrayList<String>();
        Object[] objectArray = this.structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ISchemaElement schemaElement = (ISchemaElement)element;
            String dropDDL = "DROP " + this.dropElementKeyword + " " + this.getElementName(schemaElement);
            statements.add(dropDDL);
            ++n2;
        }
        String keyspaceName = this.keyspace == null ? null : ModelUtil.escapeName((String)this.keyspace.getName());
        this.connection.execute(statements, keyspaceName, false);
    }

    private String getElementName(ISchemaElement schemaElement) {
        String elementName = schemaElement.getName();
        if ("INDEX".equalsIgnoreCase(this.dropElementKeyword)) {
            if (this.connection.getCassandraVersion().compareTo(CqlConstants.CASSANDRA_2_1_0) >= 0) {
                return ModelUtil.escapeName((String)elementName);
            }
            return elementName;
        }
        return ModelUtil.escapeName((String)elementName);
    }
}

