/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.jobs;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.cql.cql.AlterRoleStatement;
import com.datastax.devcenter.cql.cql.AlterUserStatement;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.CreateRoleStatement;
import com.datastax.devcenter.cql.cql.CreateUserStatement;
import com.datastax.devcenter.cql.cql.DropRoleStatement;
import com.datastax.devcenter.cql.cql.DropUserStatement;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractCqlResultsWorkspaceJob
extends WorkspaceJob {
    protected final Connection connection;
    protected final String name;
    protected final List<CqlStatement> statements;
    protected ResultSet resultSet;
    protected ResultSet metadataResultSet;
    protected final String defaultKeySpaceName;
    protected final boolean tracingEnabled;
    private final boolean editorContainsSelection;
    private long elapsedTime;
    protected final CqlEditorPart editor;
    protected final ConsistencyLevel consistencyLevel;

    public AbstractCqlResultsWorkspaceJob(Connection connectionHolder, List<CqlStatement> statements, String defaultKeySpaceName, CqlEditorPart editor, ConsistencyLevel consistencyLevel) {
        super(connectionHolder.getName());
        this.connection = connectionHolder;
        this.name = connectionHolder.getName();
        this.statements = statements;
        this.defaultKeySpaceName = defaultKeySpaceName;
        this.tracingEnabled = editor.isTracingEnabled();
        this.editorContainsSelection = editor.editorContainsSelection();
        this.editor = editor;
        this.consistencyLevel = consistencyLevel;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        long jobStartTime = System.currentTimeMillis();
        try {
            IStatus iStatus = this.doRunInWorkspace();
            return iStatus;
        }
        catch (Exception e) {
            Status iStatus;
            DevCenterLogger.error((String)e.toString(), (String)((Object)((Object)this)).getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
            Status status = iStatus = new Status(8, this.name, 8, e.toString(), null);
            return status;
        }
        catch (Throwable t) {
            Status iStatus;
            Status status = iStatus = new Status(8, this.name, 8, t.toString(), null);
            return status;
        }
        finally {
            this.elapsedTime = System.currentTimeMillis() - jobStartTime;
        }
    }

    protected boolean containsUserOrRoleDDL(List<CqlStatement> statements) {
        if (statements != null) {
            for (CqlStatement statement : statements) {
                if (!(statement instanceof CreateUserStatement) && !(statement instanceof AlterUserStatement) && !(statement instanceof DropUserStatement) && !(statement instanceof CreateRoleStatement) && !(statement instanceof AlterRoleStatement) && !(statement instanceof DropRoleStatement)) continue;
                return true;
            }
        }
        return false;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public ResultSet getMetadataResultSet() {
        return this.metadataResultSet;
    }

    public List<CqlStatement> getStatements() {
        return this.statements;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Long getElapsedTime() {
        return this.elapsedTime;
    }

    public boolean editorContainsSelection() {
        return this.editorContainsSelection;
    }

    protected Set<String> getSelectors() {
        return null;
    }

    protected abstract IStatus doRunInWorkspace() throws Exception;
}

