/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.jobs;

import com.datastax.devcenter.common.utils.ExportTableUtils;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.cql.ui.selection.listeners.SelectableCellTableViewer;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ResultSet;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;

public abstract class AbstractTabItem {
    protected final CqlEditorPart cqlEditorPart;
    protected final ResultSet resultSet;

    public AbstractTabItem(CqlEditorPart cqlEditorPart, ResultSet resultSet) {
        this.cqlEditorPart = cqlEditorPart;
        this.resultSet = resultSet;
    }

    abstract void createTab();

    protected void addKeyListener(final Table table) {
        table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if ((e.stateMask & 0x40000) == 0 && e.keyCode == 99) {
                    ExportTableUtils.copyToClipboard((Display)AbstractTabItem.this.getDisplay(), (String)ExportTableUtils.selectionAsCSV((Table)table, (boolean)false));
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    protected void addMenuListener(final Table table) {
        final Menu menu = new Menu((Control)table);
        table.setMenu(menu);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items;
                MenuItem[] menuItemArray = items = menu.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                AbstractTabItem.this.createCopyMenuItems(menu, table);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }

    protected void addMenuListener(final SelectableCellTableViewer tableViewer) {
        final Table table = tableViewer.getTable();
        final Menu menu = new Menu((Control)table);
        table.setMenu(menu);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items;
                MenuItem[] menuItemArray = items = menu.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                AbstractTabItem.this.createSingleCellCopyMenuItems(menu, tableViewer);
                new MenuItem(menu, 2);
                AbstractTabItem.this.createCopyMenuItems(menu, table);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }

    protected Display getDisplay() {
        return this.cqlEditorPart.getResultsTabFolder().getDisplay();
    }

    void createCopyMenuItems(Menu menu, final Table table) {
        MenuItem newItem = new MenuItem(menu, 0);
        newItem.setText("Copy Row as CSV");
        newItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportTableUtils.copyToClipboard((Display)AbstractTabItem.this.getDisplay(), (String)ExportTableUtils.selectionAsCSV((Table)table, (boolean)false));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ExportTableUtils.copyToClipboard((Display)AbstractTabItem.this.getDisplay(), (String)ExportTableUtils.selectionAsCSV((Table)table, (boolean)false));
            }
        });
        newItem = new MenuItem(menu, 0);
        newItem.setText("Copy All as CSV");
        newItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportTableUtils.copyToClipboard((Display)AbstractTabItem.this.getDisplay(), (String)ExportTableUtils.selectionAsCSV((Table)table, (boolean)true));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ExportTableUtils.copyToClipboard((Display)AbstractTabItem.this.getDisplay(), (String)ExportTableUtils.selectionAsCSV((Table)table, (boolean)false));
            }
        });
        newItem = new MenuItem(menu, 0);
        newItem.setText("Copy Row as INSERT");
        newItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportTableUtils.copyToClipboard((Display)AbstractTabItem.this.getDisplay(), (String)ExportTableUtils.selectionAsInsert((Table)table, (ColumnDefinitions)AbstractTabItem.this.resultSet.getColumnDefinitions(), (boolean)false));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ExportTableUtils.copyToClipboard((Display)AbstractTabItem.this.getDisplay(), (String)ExportTableUtils.selectionAsCSV((Table)table, (boolean)false));
            }
        });
        newItem = new MenuItem(menu, 0);
        newItem.setText("Copy All as INSERT");
        newItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportTableUtils.copyToClipboard((Display)AbstractTabItem.this.getDisplay(), (String)ExportTableUtils.selectionAsInsert((Table)table, (ColumnDefinitions)AbstractTabItem.this.resultSet.getColumnDefinitions(), (boolean)true));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ExportTableUtils.copyToClipboard((Display)AbstractTabItem.this.getDisplay(), (String)ExportTableUtils.selectionAsCSV((Table)table, (boolean)false));
            }
        });
    }

    void createSingleCellCopyMenuItems(Menu menu, final SelectableCellTableViewer tableViewer) {
        MenuItem newItem = new MenuItem(menu, 0);
        newItem.setText("Copy Cell");
        newItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportTableUtils.copyToClipboard((Display)AbstractTabItem.this.getDisplay(), (String)ExportTableUtils.columnToString((Object)tableViewer.getRawValue()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ExportTableUtils.copyToClipboard((Display)AbstractTabItem.this.getDisplay(), (String)ExportTableUtils.columnToString((Object)tableViewer.getRawValue()));
            }
        });
    }
}

