/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.jobs;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.common.metrics.Metrics;
import com.datastax.devcenter.common.status.StatusCompositeProgressMonitor;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.cql.ui.jobs.AbstractCqlResultsWorkspaceJob;
import com.datastax.devcenter.cql.ui.jobs.AbstractRowResultsTabItem;
import com.datastax.devcenter.cql.ui.jobs.JSONResultsTabItem;
import com.datastax.devcenter.cql.ui.jobs.ResultsTabItem;
import com.datastax.devcenter.cql.ui.jobs.TraceTabItem;
import com.datastax.driver.core.ResultSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExecuteCqlScriptJobChangeAdapter
extends JobChangeAdapter {
    private final Display display;
    private final CqlEditorPart cqlEditorPart;
    private AbstractRowResultsTabItem resultsTabItem;
    private static final String ERROR_DIALOG_TITLE = "Execute CQL Script";
    private static final String UNABLE_TO_EXEC_CQL_SCRIPT_ON = "Unable to execute CQL script on ";

    public ExecuteCqlScriptJobChangeAdapter(Display display, CqlEditorPart cqlEditorPart) {
        this.display = display;
        this.cqlEditorPart = cqlEditorPart;
    }

    public void done(final IJobChangeEvent iJobChangeEvent) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ExecuteCqlScriptJobChangeAdapter.this.processJobResult(iJobChangeEvent);
            }
        });
    }

    private void processJobResult(IJobChangeEvent iJobChangeEvent) {
        AbstractCqlResultsWorkspaceJob job = (AbstractCqlResultsWorkspaceJob)iJobChangeEvent.getJob();
        String statusBarMessage = "";
        String baseErrorMessage = UNABLE_TO_EXEC_CQL_SCRIPT_ON + this.getConnectionName(job);
        IStatus jobStatus = iJobChangeEvent.getResult();
        if (jobStatus.getCode() == 0) {
            List<CqlStatement> statements = job.getStatements();
            try {
                int numExecuted;
                CqlStatement lastStatement = job.getStatements().get(job.getStatements().size() - 1);
                this.createCTabFolderContents(lastStatement, job.getResultSet(), job.getMetadataResultSet());
                String stmtAdjective = "";
                if (job.editorContainsSelection()) {
                    stmtAdjective = "selected ";
                }
                statusBarMessage = (numExecuted = statements.size()) == 1 ? "1 " + stmtAdjective + "statement " : String.valueOf(numExecuted) + " " + stmtAdjective + "statements ";
                statusBarMessage = String.valueOf(statusBarMessage) + "successfully executed in " + job.getElapsedTime() + " ms";
                int numRows = this.resultsTabItem.getNumberOfRows();
                if (numRows == 1) {
                    statusBarMessage = String.valueOf(statusBarMessage) + ". Retrieved 1 row";
                } else if (numRows > 0) {
                    statusBarMessage = String.valueOf(statusBarMessage) + ". Retrieved " + numRows + " rows";
                }
            }
            catch (Exception e) {
                DevCenterLogger.error((String)e.toString(), (String)((Object)((Object)this)).getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ERROR_DIALOG_TITLE, (String)(String.valueOf(baseErrorMessage) + ": " + ((Object)((Object)this)).getClass().getName() + " - " + e.toString()));
            }
        } else {
            String jobStatusMessage = jobStatus.getMessage();
            if (StringUtils.isEmpty((String)jobStatusMessage)) {
                MessageDialog.openError((Shell)this.display.getActiveShell(), (String)ERROR_DIALOG_TITLE, (String)baseErrorMessage);
            } else {
                String nonJavaMessage = StringUtils.substringAfterLast((String)jobStatusMessage, (String)"Exception:");
                if (StringUtils.isEmpty((String)nonJavaMessage)) {
                    MessageDialog.openError((Shell)this.display.getActiveShell(), (String)ERROR_DIALOG_TITLE, (String)baseErrorMessage);
                } else {
                    MessageDialog.openError((Shell)this.display.getActiveShell(), (String)ERROR_DIALOG_TITLE, (String)(String.valueOf(baseErrorMessage) + ": " + nonJavaMessage));
                }
            }
        }
        StatusCompositeProgressMonitor progressMonitor = this.cqlEditorPart.getCqlStatusCompositeProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.deActivateProgressBar();
            progressMonitor.setMessage(statusBarMessage);
        }
        this.cqlEditorPart.setEnableExecuteCqlScript(true);
        this.cqlEditorPart.setFocus();
    }

    private String getConnectionName(AbstractCqlResultsWorkspaceJob executeCqlScriptWorkspaceJob) {
        return "'" + executeCqlScriptWorkspaceJob.getConnection().getName() + "'";
    }

    private void createCTabFolderContents(CqlStatement lastStatement, ResultSet resultSet, ResultSet metadataResultSet) {
        this.resultsTabItem = this.getResultsTabForStatement(lastStatement, resultSet, metadataResultSet);
        this.resultsTabItem.createTab();
        TraceTabItem traceTabItem = new TraceTabItem(this.cqlEditorPart, resultSet);
        traceTabItem.createTab();
        CTabFolder ctabFolder = this.cqlEditorPart.getResultsTabFolder();
        if (ctabFolder.getSelection() == null) {
            ctabFolder.setSelection(this.cqlEditorPart.getResultsTabItem());
        }
        ctabFolder.layout(true, true);
        ctabFolder.update();
        ctabFolder.redraw();
        ctabFolder.setFocus();
    }

    private AbstractRowResultsTabItem getResultsTabForStatement(CqlStatement lastStatement, ResultSet resultSet, ResultSet metadataResultSet) {
        if (lastStatement instanceof SelectStatement && ((SelectStatement)lastStatement).isJsonSelect()) {
            Metrics.incrementCounter((String)"json_results_tab_count");
            this.resultsTabItem = new JSONResultsTabItem(this.cqlEditorPart, resultSet, (SelectStatement)lastStatement);
        } else {
            Metrics.incrementCounter((String)"standard_results_tab_count");
            this.resultsTabItem = new ResultsTabItem(this.cqlEditorPart, resultSet, metadataResultSet);
        }
        return this.resultsTabItem;
    }
}

