/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.jobs;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.util.IMetadataStatement;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.cql.ui.jobs.AbstractCqlResultsWorkspaceJob;
import com.datastax.devcenter.cql.ui.jobs.MetadataSelectStatement;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ExecuteCqlScriptMetadataWorkspaceJob
extends AbstractCqlResultsWorkspaceJob {
    private final MetadataSelectStatement metadataSelectStatement;

    public ExecuteCqlScriptMetadataWorkspaceJob(Connection connectionHolder, List<CqlStatement> statements, MetadataSelectStatement metadataSelectStatement, String defaultKeySpaceName, CqlEditorPart editor, ConsistencyLevel consistencyLevel) {
        super(connectionHolder, statements, defaultKeySpaceName, editor, consistencyLevel);
        this.metadataSelectStatement = metadataSelectStatement;
    }

    @Override
    protected IStatus doRunInWorkspace() throws Exception {
        List<ResultSet> resultSets;
        List serialQueries = null;
        if (this.statements.size() > 1) {
            serialQueries = this.statements.subList(0, this.statements.size() - 1);
        }
        if ((resultSets = this.executeStatements(serialQueries, this.metadataSelectStatement, this.tracingEnabled)) == null) {
            return new Status(8, this.name, 8, "", null);
        }
        this.resultSet = resultSets.get(0);
        this.metadataResultSet = resultSets.size() > 1 ? resultSets.get(1) : null;
        return new Status(0, this.name, 0, "cql script execution successful", null);
    }

    public List<ResultSet> executeStatements(List<CqlStatement> statements, MetadataSelectStatement metadataSelect, boolean tracingEnabled) throws Exception {
        List<String> queries = statements != null ? this.editor.getStringValue(statements) : null;
        String selectStmt = this.editor.getStringValue((CqlStatement)metadataSelect.getSelectStatement());
        try {
            List resultSets = this.connection.execute(queries, selectStmt, (IMetadataStatement)metadataSelect, ModelUtil.escapeName((String)this.defaultKeySpaceName), tracingEnabled, this.consistencyLevel);
            if (this.containsUserOrRoleDDL(statements)) {
                this.connection.fireConnectionChanged();
            }
            return resultSets;
        }
        catch (Exception e) {
            DevCenterLogger.error((String)e.toString(), (String)((Object)((Object)this)).getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
            throw new Exception(e);
        }
    }

    @Override
    protected Set<String> getSelectors() {
        return this.metadataSelectStatement.getInjectedSelectors();
    }
}

