/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.jobs;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.cql.ui.jobs.AbstractCqlResultsWorkspaceJob;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ExecuteCqlScriptWorkspaceJob
extends AbstractCqlResultsWorkspaceJob {
    public ExecuteCqlScriptWorkspaceJob(Connection connectionHolder, List<CqlStatement> statements, String defaultKeySpaceName, CqlEditorPart editor, ConsistencyLevel consistencyLevel) {
        super(connectionHolder, statements, defaultKeySpaceName, editor, consistencyLevel);
    }

    @Override
    protected IStatus doRunInWorkspace() throws Exception {
        this.resultSet = this.executeStatements(this.statements, this.tracingEnabled);
        if (this.resultSet == null) {
            return new Status(8, this.name, 8, "", null);
        }
        Status iStatus = new Status(0, this.name, 0, "cql script execution successful", null);
        return iStatus;
    }

    public ResultSet executeStatements(List<CqlStatement> statements, boolean tracingEnabled) throws Exception {
        List<String> queries = statements != null ? this.editor.getStringValue(statements) : null;
        try {
            ResultSet resultSet = this.connection.execute(queries, ModelUtil.escapeName((String)this.defaultKeySpaceName), tracingEnabled, this.consistencyLevel);
            if (this.containsUserOrRoleDDL(statements)) {
                this.connection.fireConnectionChanged();
            }
            return resultSet;
        }
        catch (Exception e) {
            DevCenterLogger.error((String)e.toString(), (String)((Object)((Object)this)).getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
            throw new Exception(e);
        }
    }
}

