/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.jobs;

import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.CqlContextProvider;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.SelectClause;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.Selector;
import com.datastax.devcenter.cql.ui.CqlActivator;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.cql.ui.editor.embedded.EmbeddedJsonViewer;
import com.datastax.devcenter.cql.ui.jobs.AbstractRowResultsTabItem;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Table;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class JSONResultsTabItem
extends AbstractRowResultsTabItem {
    private List<String> jsonResults = new ArrayList<String>();
    private SelectStatement cqlStatement;

    public JSONResultsTabItem(CqlEditorPart cqlEditorPart, ResultSet resultSet, SelectStatement cqlStatement) {
        super(cqlEditorPart, resultSet);
        this.cqlStatement = cqlStatement;
    }

    @Override
    public int getNumberOfRows() {
        return this.jsonResults.size();
    }

    @Override
    void createTab() {
        Composite composite = new Composite((Composite)this.cqlEditorPart.getResultsTabFolder(), 0);
        composite.setLayout((Layout)new GridLayout());
        Iterator rows = this.resultSet.iterator();
        while (rows.hasNext()) {
            this.jsonResults.add(((Row)rows.next()).getString(0));
        }
        int numberOfFieldsBeforeFirstLineBreak = this.getNumberOfFieldsBeforeLineFirstLineBreak((CqlStatement)this.cqlStatement);
        EmbeddedJsonViewer viewer = EmbeddedJsonViewer.buildJsonViewer(this.jsonResults, numberOfFieldsBeforeFirstLineBreak, composite);
        viewer.renderView();
        CTabItem resultsCTabItem = this.cqlEditorPart.getResultsTabItem();
        resultsCTabItem.setControl((Control)composite);
    }

    protected int getNumberOfFieldsBeforeLineFirstLineBreak(CqlStatement lastStatement) {
        Injector injector = CqlActivator.getDefault().getInjector("com.datastax.devcenter.cql.Cql");
        CqlContextProvider cqlContextProvider = (CqlContextProvider)injector.getInstance(CqlContextProvider.class);
        CqlContext cqlContext = cqlContextProvider.get((EObject)lastStatement);
        Table tableMetadata = cqlContext.getTableMeta((EObject)lastStatement);
        if (tableMetadata != null) {
            List primaryKeys = tableMetadata.getPrimaryKeys();
            HashSet<String> primaryKeyColumnNames = new HashSet<String>();
            if (primaryKeys != null) {
                for (Column c : primaryKeys) {
                    primaryKeyColumnNames.add(c.getName().toLowerCase());
                }
                int numberOfPrimaryKeyColumns = this.determineLastFieldOnFirstLineBasedOnPrimaryKeysAndSelectClause(lastStatement, primaryKeyColumnNames);
                return numberOfPrimaryKeyColumns > 0 ? numberOfPrimaryKeyColumns : 1;
            }
        }
        return 1;
    }

    public int determineLastFieldOnFirstLineBasedOnPrimaryKeysAndSelectClause(CqlStatement cqlStatement, Set<String> primaryKeyColumnNames) {
        int lastFieldNumber = 1;
        if (cqlStatement instanceof SelectStatement) {
            SelectStatement selectStatement = (SelectStatement)cqlStatement;
            if (selectStatement.getSelectClause().isAll()) {
                lastFieldNumber = primaryKeyColumnNames.size() > 0 ? primaryKeyColumnNames.size() : 1;
            } else {
                SelectClause selectClause = selectStatement.getSelectClause();
                int index = 0;
                while (index < selectClause.getSelectors().size()) {
                    Selector selector = (Selector)selectClause.getSelectors().get(index);
                    if (selector.getColumn() != null && selector.getColumn().getName() != null && primaryKeyColumnNames.contains(selector.getColumn().getName().toLowerCase())) {
                        lastFieldNumber = index + 1;
                    }
                    ++index;
                }
            }
        }
        return lastFieldNumber;
    }
}

