/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.jobs;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.util.IMetadataStatement;
import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.CqlStandaloneSetupGenerated;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.SelectClause;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.Selector;
import com.datastax.devcenter.cql.cql.SelectorTTL;
import com.datastax.devcenter.cql.cql.SelectorWritetime;
import com.datastax.devcenter.cql.parser.antlr.CqlParser;
import com.datastax.devcenter.cql.services.CqlGrammarAccess;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Table;
import com.google.inject.Injector;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.serializer.ISerializer;

public class MetadataSelectStatement
implements IMetadataStatement {
    private SelectStatement selectStatement;
    private SelectStatement metadataSelectStatement;
    private Set<String> injectedSelectors;
    private CqlEditorPart editor;
    private static CqlParser parser;
    private static ParserRule selectStmtRule;
    private static ISerializer serializer;

    static {
        CqlStandaloneSetupGenerated activator = new CqlStandaloneSetupGenerated();
        Injector injector = activator.createInjector();
        parser = (CqlParser)injector.getInstance(CqlParser.class);
        serializer = (ISerializer)injector.getInstance(ISerializer.class);
        CqlGrammarAccess access = (CqlGrammarAccess)injector.getInstance(CqlGrammarAccess.class);
        selectStmtRule = access.getSelectStatementRule();
    }

    public MetadataSelectStatement(CqlEditorPart editor, SelectStatement selectStatement) {
        this.selectStatement = selectStatement;
        this.editor = editor;
    }

    public MetadataSelectStatement(Table table, SelectStatement selectStatement) {
        this.selectStatement = selectStatement;
        this.metadataSelectStatement = this.injectSelectors(table, selectStatement);
    }

    private SelectStatement injectSelectors(Table table, SelectStatement selectStatement) {
        SelectStatement metaSelectStatement = this.copy(selectStatement);
        SelectClause metadataSelectors = CqlFactory.eINSTANCE.createSelectClause();
        metaSelectStatement.setSelectClause(metadataSelectors);
        SelectClause originalSelectors = selectStatement.getSelectClause();
        Set<Object> injectedMetadataSelectors = new HashSet();
        if (table != null) {
            injectedMetadataSelectors = originalSelectors.isAll() ? this.handleSelectAll(table, metadataSelectors) : this.handleSelectors(table, originalSelectors, metadataSelectors);
        }
        this.injectedSelectors = Collections.unmodifiableSet(injectedMetadataSelectors);
        if (this.injectedSelectors.isEmpty()) {
            return null;
        }
        return metaSelectStatement;
    }

    private Set<String> handleSelectAll(Table table, SelectClause metadataSelectClause) {
        SelectClause selectAllClause = CqlFactory.eINSTANCE.createSelectClause();
        selectAllClause.setAll(false);
        EList allSelectors = selectAllClause.getSelectors();
        List columns = table.getColumns();
        for (Column column : columns) {
            String columnName = column.getName();
            if (columnName == null || columnName.trim().isEmpty()) continue;
            this.addSelector((EList<Selector>)allSelectors, columnName);
        }
        return this.handleSelectors(table, selectAllClause, metadataSelectClause);
    }

    private Set<String> handleSelectors(Table table, SelectClause originalSelectClause, SelectClause metadataSelectClause) {
        HashSet<String> injectedMetadataSelectors = new HashSet<String>();
        EList originalSelectors = originalSelectClause.getSelectors();
        EList metadataSelectors = metadataSelectClause.getSelectors();
        for (Selector selector : originalSelectors) {
            if (selector.getColumn() == null || this.skipColumn(table, selector)) continue;
            String columnName = selector.getColumn().getName();
            String ttlSelectorName = MetadataSelectStatement.geTtlName(columnName);
            String timestampSelectorName = MetadataSelectStatement.getTimestampName(columnName);
            this.addTtl((EList<Selector>)metadataSelectors, columnName);
            injectedMetadataSelectors.add(ttlSelectorName);
            this.addTimestamp((EList<Selector>)metadataSelectors, columnName);
            injectedMetadataSelectors.add(timestampSelectorName);
        }
        return injectedMetadataSelectors;
    }

    private void addTtl(EList<Selector> selectors, String columnName) {
        ColumnEntity ttlColumn = CqlFactory.eINSTANCE.createColumnEntity();
        ttlColumn.setName(columnName);
        SelectorTTL ttlSelector = CqlFactory.eINSTANCE.createSelectorTTL();
        ttlSelector.setColumn(ttlColumn);
        Selector ttlSelectorWrapper = CqlFactory.eINSTANCE.createSelector();
        ttlSelectorWrapper.setTtl(ttlSelector);
        selectors.add((Object)ttlSelectorWrapper);
    }

    private void addTimestamp(EList<Selector> selectors, String columnName) {
        ColumnEntity timestampColumn = CqlFactory.eINSTANCE.createColumnEntity();
        timestampColumn.setName(columnName);
        SelectorWritetime timestampSelector = CqlFactory.eINSTANCE.createSelectorWritetime();
        timestampSelector.setColumn(timestampColumn);
        Selector timestampSelectorWrapper = CqlFactory.eINSTANCE.createSelector();
        timestampSelectorWrapper.setWritetime(timestampSelector);
        selectors.add((Object)timestampSelectorWrapper);
    }

    private void addSelector(EList<Selector> selectors, String columnName) {
        ColumnEntity columnEntity = CqlFactory.eINSTANCE.createColumnEntity();
        columnEntity.setName(ModelUtil.escapeName((String)columnName));
        Selector selector = CqlFactory.eINSTANCE.createSelector();
        selector.setColumn(columnEntity);
        selectors.add((Object)selector);
    }

    public static String geTtlName(String columnName) {
        return String.format("ttl(%s)", columnName);
    }

    public static String getTimestampName(String columnName) {
        return String.format("writetime(%s)", columnName);
    }

    private boolean skipColumn(Table table, Selector selector) {
        String columnName = selector.getColumn().getName();
        if (table == null) {
            return true;
        }
        if (table.isPrimaryKeyContain(ModelUtil.stripName((String)columnName))) {
            return true;
        }
        Column column = table.getColumn(ModelUtil.stripName((String)columnName));
        if (column == null) {
            return true;
        }
        if (column.getType().isCollection()) {
            return true;
        }
        EList udts = selector.getUserTypeFields();
        return udts != null && !udts.isEmpty();
    }

    public Set<String> getInjectedSelectors() {
        return this.injectedSelectors;
    }

    public SelectStatement getSelectStatement() {
        return this.selectStatement;
    }

    public SelectStatement getMetadataSelectStatement() {
        return this.metadataSelectStatement;
    }

    public static boolean shouldRequestMetadata(CqlStatement statement) {
        if (statement == null || !(statement instanceof SelectStatement)) {
            return false;
        }
        SelectStatement select = (SelectStatement)statement;
        return !select.isJsonSelect() && select.getSelectClause() != null && select.getSelectCountClause() == null && !ModelUtil.isSolrQuery((SelectStatement)select);
    }

    public void injectSelectors(Connection connection) {
        if (this.editor == null || this.editor.getContext() == null) {
            return;
        }
        CqlContext context = this.editor.getContext();
        Table table = context.getTableMeta((EObject)this.selectStatement);
        if (table == null) {
            context.updateDatabaseSchemaAndReset(connection);
            table = context.getTableMeta((EObject)this.selectStatement);
        }
        this.metadataSelectStatement = this.injectSelectors(table, this.selectStatement);
    }

    public String getMetadataStatement() {
        if (this.metadataSelectStatement != null) {
            return this.editor.getStringValue((CqlStatement)this.metadataSelectStatement);
        }
        return null;
    }

    private SelectStatement copy(SelectStatement stmt) {
        IParseResult result = parser.parse(selectStmtRule, (Reader)new StringReader(serializer.serialize((EObject)stmt)));
        return (SelectStatement)result.getRootNode().getSemanticElement();
    }
}

