/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.jobs;

import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.cql.ui.jobs.AbstractRowResultsTabItem;
import com.datastax.devcenter.cql.ui.providers.CqlResultsContentProvider;
import com.datastax.devcenter.cql.ui.providers.CqlResultsLabelProvider;
import com.datastax.devcenter.cql.ui.providers.editing_support.CqlTextEditingSupport;
import com.datastax.devcenter.cql.ui.selection.listeners.CqlResultsCellSelectionListener;
import com.datastax.devcenter.cql.ui.selection.listeners.SelectableCellTableViewer;
import com.datastax.devcenter.cql.ui.sorters.ComparableColumnViewerSorter;
import com.datastax.devcenter.cql.ui.sorters.InetColumnViewerSorter;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ResultsTabItem
extends AbstractRowResultsTabItem {
    private CqlResultsContentProvider contentProvider;
    private int numberOfColumns;
    private ResultSet metadataResultSet;

    public ResultsTabItem(CqlEditorPart cqlEditorPart, ResultSet resultSet, ResultSet metadataResultSet) {
        super(cqlEditorPart, resultSet);
        this.metadataResultSet = metadataResultSet;
        ColumnDefinitions columnDefinitions = resultSet.getColumnDefinitions();
        this.numberOfColumns = columnDefinitions.size();
    }

    @Override
    public void createTab() {
        Composite composite = new Composite((Composite)this.cqlEditorPart.getResultsTabFolder(), 0);
        this.createResultsTab(composite);
        CTabItem resultsCTabItem = this.cqlEditorPart.getResultsTabItem();
        resultsCTabItem.setControl((Control)composite);
    }

    private void createResultsTab(Composite parent) {
        TableColumnLayout tableLayout = new TableColumnLayout();
        parent.setLayout((Layout)tableLayout);
        SelectableCellTableViewer tableViewer = new SelectableCellTableViewer(parent, 66304);
        CqlResultsCellSelectionListener cellSelectionListener = new CqlResultsCellSelectionListener();
        tableViewer.addSelectionChangedListener(cellSelectionListener);
        this.createResultsetTableColumns(tableLayout, tableViewer.getInnerTableViewer());
        this.contentProvider = new CqlResultsContentProvider();
        this.contentProvider.setNumberOfColumns(this.numberOfColumns);
        tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        tableViewer.setInput(new ResultSet[]{this.resultSet, this.metadataResultSet});
        tableViewer.getTable().setRedraw(true);
        tableViewer.refresh();
        Table table = tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.addKeyListener(table);
        this.addMenuListener(tableViewer);
        tableViewer.refresh();
    }

    @Override
    public int getNumberOfRows() {
        return this.contentProvider.getNumberOfRows();
    }

    private void createResultsetTableColumns(TableColumnLayout tableLayout, TableViewer cqlTableViewer) {
        int columnIndex = 0;
        List definitions = this.resultSet.getColumnDefinitions().asList();
        int i = 0;
        while (i < this.numberOfColumns) {
            String columnHeader = ((ColumnDefinitions.Definition)definitions.get(i)).getName();
            DataType columnType = ((ColumnDefinitions.Definition)definitions.get(i)).getType();
            TableViewerColumn tableViewerColumn = new TableViewerColumn(cqlTableViewer, 0);
            TableColumn column = tableViewerColumn.getColumn();
            column.setText(columnHeader);
            column.setAlignment(16384);
            column.setMoveable(false);
            tableLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 100, true));
            switch (columnType.getName()) {
                case BLOB: 
                case LIST: 
                case SET: 
                case MAP: 
                case CUSTOM: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CqlResultsLabelProvider(columnIndex));
                    break;
                }
                case INET: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CqlResultsLabelProvider(columnIndex));
                    new InetColumnViewerSorter((ColumnViewer)cqlTableViewer, tableViewerColumn, columnIndex);
                    break;
                }
                default: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CqlResultsLabelProvider(columnIndex));
                    tableViewerColumn.setEditingSupport((EditingSupport)new CqlTextEditingSupport(cqlTableViewer, columnIndex));
                    new ComparableColumnViewerSorter((ColumnViewer)cqlTableViewer, tableViewerColumn, columnIndex);
                }
            }
            ++columnIndex;
            ++i;
        }
    }
}

