/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.jobs;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.common.metrics.Metrics;
import com.datastax.devcenter.common.utils.IconUtility;
import com.datastax.devcenter.cql.ui.CqlActivator;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.cql.ui.jobs.AbstractTabItem;
import com.datastax.devcenter.cql.ui.jobs.InfoMessagePopupDialog;
import com.datastax.devcenter.cql.ui.providers.TraceTableContentProvider;
import com.datastax.devcenter.cql.ui.sorters.ComparableColumnViewerSorter;
import com.datastax.devcenter.cql.ui.sorters.InetColumnViewerSorter;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.exceptions.TraceRetrievalException;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class TraceTabItem
extends AbstractTabItem {
    private final List<Image> sourceNodeImages = new ArrayList<Image>();
    private List<InetAddress> sourceNodeList;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.");

    public TraceTabItem(CqlEditorPart cqlEditorPart, ResultSet resultSet) {
        super(cqlEditorPart, resultSet);
        try {
            this.sourceNodeImages.add(IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/dot_green.gif").createImage());
            this.sourceNodeImages.add(IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/dot_light_blue.gif").createImage());
            this.sourceNodeImages.add(IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/dot_light_purple.gif").createImage());
            this.sourceNodeImages.add(IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/dot_orange.gif").createImage());
            this.sourceNodeImages.add(IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/dot_red.gif").createImage());
            this.sourceNodeImages.add(IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/dot_teal.gif").createImage());
            this.sourceNodeImages.add(IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/dot_yellow.gif").createImage());
            this.sourceNodeImages.add(IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/dot_dark_blue.gif").createImage());
            this.sourceNodeImages.add(IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/dot_dark_purple.gif").createImage());
            this.sourceNodeImages.add(IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/dot_black.gif").createImage());
            this.sourceNodeImages.add(IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/dot_grey.gif").createImage());
            this.sourceNodeImages.add(IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/dot_pink.gif").createImage());
        }
        catch (Exception e) {
            DevCenterLogger.error((String)e.toString(), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
    }

    @Override
    void createTab() {
        CTabFolder cTabFolder = this.cqlEditorPart.getResultsTabFolder();
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)cTabFolder, 2564);
        Composite composite = new Composite((Composite)scrolledComposite, 4);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(cTabFolder.getBackground());
        composite.setBackgroundMode(1);
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        CTabItem traceCTabItem = this.cqlEditorPart.getTraceTabItem();
        traceCTabItem.setControl((Control)scrolledComposite);
        traceCTabItem.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                Metrics.incrementCounter((String)"query_trace_tab_count");
            }
        });
        traceCTabItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Metrics.incrementCounter((String)"query_trace_tab_count");
            }
        });
        this.createTraceTab(composite);
        scrolledComposite.setMinHeight(cTabFolder.computeSize((int)-1, (int)-1).y);
    }

    private void createTraceTab(Composite parent) {
        try {
            this.createTraceIdSection(parent);
            this.buildSourceNodeIndex();
            this.createTraceNodeInfoSection(parent);
            this.createRoleInfoSection(parent);
            this.createTraceTable(parent);
        }
        catch (TraceRetrievalException tre) {
            this.createUnableToRetrieveTrace(parent, tre);
        }
        catch (Exception e) {
            DevCenterLogger.error((String)e.toString(), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
    }

    private void createTraceIdSection(Composite ctabItemComposite) {
        Composite traceIdComposite = new Composite(ctabItemComposite, 4);
        traceIdComposite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        traceIdComposite.setLayoutData((Object)gridData);
        Label traceIdLabel = new Label(traceIdComposite, 0);
        traceIdLabel.setText("Trace session id: ");
        final Text traceIdText = new Text(traceIdComposite, 0);
        QueryTrace queryTrace = this.resultSet.getExecutionInfo().getQueryTrace();
        traceIdText.setText(queryTrace.getTraceId().toString());
        traceIdText.setEnabled(true);
        traceIdText.setEditable(false);
        traceIdText.clearSelection();
        final StringBuilder traceHelpStrBuilder = new StringBuilder().append("Tracing session information is stored for 24 hours. Session and session event data can be queried with:").append(Text.DELIMITER).append("SELECT * FROM system_traces.sessions WHERE session_id = ").append(queryTrace.getTraceId().toString()).append(";").append(Text.DELIMITER).append("SELECT * FROM system_traces.events WHERE session_id = ").append(queryTrace.getTraceId().toString()).append(";").append(Text.DELIMITER);
        Link traceIdInfoLink = new Link(traceIdComposite, 0);
        traceIdInfoLink.setText("[ <a>more</a> ]");
        traceIdInfoLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                new InfoMessagePopupDialog(new Shell(), (Control)traceIdText, traceHelpStrBuilder.toString()).open();
            }
        });
    }

    private void buildSourceNodeIndex() {
        this.sourceNodeList = new ArrayList<InetAddress>();
        QueryTrace queryTrace = this.resultSet.getExecutionInfo().getQueryTrace();
        for (QueryTrace.Event event : queryTrace.getEvents()) {
            InetAddress source = event.getSource();
            if (this.sourceNodeList.contains(source)) continue;
            this.sourceNodeList.add(source);
        }
    }

    private void createTraceNodeInfoSection(final Composite ctabItemComposite) {
        ExpandableComposite expandableComposite = new ExpandableComposite(ctabItemComposite, 4, 16386);
        expandableComposite.setLayout((Layout)new GridLayout(1, false));
        expandableComposite.setLayoutData((Object)new GridData(1, 4, true, false));
        expandableComposite.setText("Node information");
        expandableComposite.setExpanded(true);
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ctabItemComposite.layout(true);
            }
        });
        Composite traceInfoComposite = new Composite((Composite)expandableComposite, 4);
        GridLayout traceInfoGridLayout = new GridLayout(2, false);
        traceInfoGridLayout.horizontalSpacing = 0;
        traceInfoComposite.setLayout((Layout)traceInfoGridLayout);
        traceInfoComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        expandableComposite.setClient((Control)traceInfoComposite);
        for (InetAddress node : this.sourceNodeList) {
            Label nodeImageLabel = new Label(traceInfoComposite, 0);
            nodeImageLabel.setImage(this.getSourceNodeImage(node));
            Text nodeText = new Text(traceInfoComposite, 0);
            nodeText.setText(node.getHostAddress());
        }
    }

    private Image getSourceNodeImage(InetAddress element) {
        int nodeIndex = this.sourceNodeList.indexOf(element);
        return this.sourceNodeImages.get(nodeIndex % this.sourceNodeImages.size());
    }

    private void createRoleInfoSection(final Composite ctabItemComposite) {
        ExpandableComposite expandableComposite = new ExpandableComposite(ctabItemComposite, 4, 16386);
        expandableComposite.setLayout((Layout)new GridLayout(1, false));
        expandableComposite.setLayoutData((Object)new GridData(1, 4, true, false));
        expandableComposite.setText("Role information");
        expandableComposite.setExpanded(true);
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ctabItemComposite.layout(true);
            }
        });
        Composite traceInfoComposite = new Composite((Composite)expandableComposite, 4);
        GridLayout traceInfoGridLayout = new GridLayout(2, false);
        traceInfoGridLayout.horizontalSpacing = 0;
        traceInfoComposite.setLayout((Layout)traceInfoGridLayout);
        traceInfoComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        expandableComposite.setClient((Control)traceInfoComposite);
        Text nodeText1 = new Text(traceInfoComposite, 0);
        nodeText1.setText("C");
        Text nodeText2 = new Text(traceInfoComposite, 0);
        nodeText2.setText("- Coordinator node");
        nodeText1 = new Text(traceInfoComposite, 0);
        nodeText1.setText("R");
        nodeText2 = new Text(traceInfoComposite, 0);
        nodeText2.setText("- Replica node");
        nodeText1 = new Text(traceInfoComposite, 0);
        nodeText1.setText("CR");
        nodeText2 = new Text(traceInfoComposite, 0);
        nodeText2.setText("- Coordinator and Replica node");
    }

    private void createTraceTable(Composite ctabItemComposite) {
        Composite composite = new Composite(ctabItemComposite, 4);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        Composite traceTableComposite = new Composite(composite, 4);
        TableColumnLayout tableLayout = new TableColumnLayout();
        traceTableComposite.setLayout((Layout)tableLayout);
        TableViewer tableViewer = new TableViewer(traceTableComposite, 66306);
        this.createTraceTableColumns(tableLayout, tableViewer);
        TraceTableContentProvider traceContentProvider = new TraceTableContentProvider();
        tableViewer.setContentProvider((IContentProvider)traceContentProvider);
        tableViewer.setInput((Object)this.resultSet);
        Table table = tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.addKeyListener(table);
        tableViewer.refresh();
    }

    private void createTraceTableColumns(TableColumnLayout tableLayout, TableViewer viewer) {
        TableViewerColumn col = this.createTableViewerColumn(tableLayout, viewer, "Activity", 375);
        new ComparableColumnViewerSorter((ColumnViewer)viewer, col, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Object[] objectArray = (Object[])element;
                String description = (String)objectArray[0];
                return description.replace('\n', ' ');
            }
        });
        col = this.createTableViewerColumn(tableLayout, viewer, "Timestamp", 110);
        new ComparableColumnViewerSorter((ColumnViewer)viewer, col, 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Object[] objectArray = (Object[])element;
                long timestampInMicros = (Long)objectArray[1];
                return TraceTabItem.this.microsecondsToDate(timestampInMicros);
            }
        });
        col = this.createTableViewerColumn(tableLayout, viewer, "Role", 50);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                Object[] objectArray = (Object[])element;
                TraceTableContentProvider.SourceNodeRole role = (TraceTableContentProvider.SourceNodeRole)((Object)objectArray[3]);
                switch (role) {
                    case COORDINATOR: {
                        return "C";
                    }
                    case BOTH: {
                        return "CR";
                    }
                }
                return "R";
            }
        });
        col = this.createTableViewerColumn(tableLayout, viewer, "Source node", 110);
        new InetColumnViewerSorter((ColumnViewer)viewer, col, 2);
        SourceNodeLabelProvider sourceLabelProvider = new SourceNodeLabelProvider();
        col.setLabelProvider((CellLabelProvider)sourceLabelProvider);
        col = this.createTableViewerColumn(tableLayout, viewer, "Source elapsed (\u00b5s)", 110);
        col.getColumn().setAlignment(131072);
        new ComparableColumnViewerSorter((ColumnViewer)viewer, col, 4);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Object[] objectArray = (Object[])element;
                int elapsedMicros = (Integer)objectArray[4];
                return String.format("%6d", elapsedMicros);
            }
        });
        col = this.createTableViewerColumn(tableLayout, viewer, "Thread", 120);
        new ComparableColumnViewerSorter((ColumnViewer)viewer, col, 5);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Object[] objectArray = (Object[])element;
                return (String)objectArray[5];
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(TableColumnLayout tableLayout, TableViewer viewer, String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        tableLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, bound, true));
        return viewerColumn;
    }

    private String microsecondsToDate(long timestampInMicros) {
        return String.valueOf(dateFormat.format(timestampInMicros / 1000L)) + String.format("%06d", timestampInMicros % 100000L);
    }

    private void createUnableToRetrieveTrace(Composite ctabItemComposite, TraceRetrievalException tre) {
        Composite composite = new Composite(ctabItemComposite, 4);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        final Label unableToRetrieveTraceLabel = new Label(composite, 0);
        unableToRetrieveTraceLabel.setText("Unable to retrieve Query Trace information");
        unableToRetrieveTraceLabel.setFont(JFaceResources.getFontRegistry().getItalic(""));
        final StringBuilder sb = new StringBuilder();
        sb.append("Exception:").append(Text.DELIMITER).append(tre.toString()).append(Text.DELIMITER);
        if (tre.getCause() != null) {
            sb.append("Caused By:").append(Text.DELIMITER).append(tre.getCause().toString()).append(Text.DELIMITER);
        }
        Link traceIdInfoLink = new Link(composite, 0);
        traceIdInfoLink.setText("[ <a>more</a> ]");
        traceIdInfoLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                new InfoMessagePopupDialog(new Shell(), (Control)unableToRetrieveTraceLabel, sb.toString()).open();
            }
        });
    }

    class SourceNodeLabelProvider
    extends ColumnLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        SourceNodeLabelProvider() {
        }

        public String getText(Object element) {
            Object[] objectArray = (Object[])element;
            InetAddress source = (InetAddress)objectArray[2];
            return InetAddresses.toAddrString((InetAddress)source);
        }

        public Image getImage(Object element) {
            Object[] objectArray = (Object[])element;
            InetAddress source = (InetAddress)objectArray[2];
            return TraceTabItem.this.getSourceNodeImage(source);
        }

        public StyledString getStyledText(Object element) {
            return new StyledString(this.getText(element));
        }
    }
}

