/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.labeling;

import com.datastax.devcenter.cql.cql.AlterKeyspaceStatement;
import com.datastax.devcenter.cql.cql.AlterRoleStatement;
import com.datastax.devcenter.cql.cql.AlterTableStatement;
import com.datastax.devcenter.cql.cql.AlterTypeStatement;
import com.datastax.devcenter.cql.cql.AlterUserStatement;
import com.datastax.devcenter.cql.cql.BatchStatement;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.CreateAggregateFunctionStatement;
import com.datastax.devcenter.cql.cql.CreateFunctionStatement;
import com.datastax.devcenter.cql.cql.CreateIndexStatement;
import com.datastax.devcenter.cql.cql.CreateKeyspaceStatement;
import com.datastax.devcenter.cql.cql.CreateRoleStatement;
import com.datastax.devcenter.cql.cql.CreateTableStatement;
import com.datastax.devcenter.cql.cql.CreateTriggerStatement;
import com.datastax.devcenter.cql.cql.CreateTypeStatement;
import com.datastax.devcenter.cql.cql.CreateUserStatement;
import com.datastax.devcenter.cql.cql.DeleteStatement;
import com.datastax.devcenter.cql.cql.DropFunctionStatement;
import com.datastax.devcenter.cql.cql.DropIndexStatement;
import com.datastax.devcenter.cql.cql.DropKeyspaceStatement;
import com.datastax.devcenter.cql.cql.DropRoleStatement;
import com.datastax.devcenter.cql.cql.DropTableStatement;
import com.datastax.devcenter.cql.cql.DropTriggerStatement;
import com.datastax.devcenter.cql.cql.DropTypeStatement;
import com.datastax.devcenter.cql.cql.DropUserStatement;
import com.datastax.devcenter.cql.cql.GrantStatement;
import com.datastax.devcenter.cql.cql.InsertStatement;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.ListPermissionsStatement;
import com.datastax.devcenter.cql.cql.ListRolesStatement;
import com.datastax.devcenter.cql.cql.ListUsersStatement;
import com.datastax.devcenter.cql.cql.RevokeStatement;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.TruncateStatement;
import com.datastax.devcenter.cql.cql.UpdateStatement;
import com.datastax.devcenter.cql.cql.UseStatement;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

public class CqlLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    public CqlLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    public String combineKeyspaceTableName(CqlStatement stmt) {
        if (stmt == null) {
            return "";
        }
        TableEntity table = ModelUtil.getTable((CqlStatement)stmt);
        if (table == null) {
            return "";
        }
        KeyspaceEntity keyspace = ModelUtil.getKeyspace((CqlStatement)stmt);
        if (keyspace == null) {
            return table.getName();
        }
        return String.valueOf(keyspace.getName()) + "." + table.getName();
    }

    private StyledString styling(String prompt, String name) {
        StyledString s = new StyledString();
        s.append(prompt, StyledString.DECORATIONS_STYLER);
        s.append(name);
        return s;
    }

    public StyledString text(SelectStatement stmt) {
        return this.styling("SELECT FROM ", this.combineKeyspaceTableName((CqlStatement)stmt));
    }

    public StyledString text(InsertStatement stmt) {
        return this.styling("INSERT INTO ", this.combineKeyspaceTableName((CqlStatement)stmt));
    }

    public StyledString text(UpdateStatement stmt) {
        return this.styling("UPDATE ", this.combineKeyspaceTableName((CqlStatement)stmt));
    }

    public StyledString text(BatchStatement stmt) {
        return this.styling("BATCH", "");
    }

    public StyledString text(DeleteStatement stmt) {
        return this.styling("DELETE FROM ", this.combineKeyspaceTableName((CqlStatement)stmt));
    }

    public StyledString text(UseStatement stmt) {
        return this.styling("USE ", stmt.getKeyspace().getName());
    }

    public StyledString text(TruncateStatement stmt) {
        return this.styling("TRUNCATE ", this.combineKeyspaceTableName((CqlStatement)stmt));
    }

    public StyledString text(CreateKeyspaceStatement stmt) {
        return this.styling("CREATE KEYSPACE ", stmt.getKeyspace().getName());
    }

    public StyledString text(CreateTableStatement stmt) {
        return this.styling("CREATE TABLE ", this.combineKeyspaceTableName((CqlStatement)stmt));
    }

    public StyledString text(CreateIndexStatement stmt) {
        return this.styling("CREATE INDEX ON ", this.combineKeyspaceTableName((CqlStatement)stmt));
    }

    public StyledString text(DropKeyspaceStatement stmt) {
        return this.styling("DROP KEYSPACE ", stmt.getKeyspace().getName());
    }

    public StyledString text(DropTableStatement stmt) {
        return this.styling("DROP TABLE ", this.combineKeyspaceTableName((CqlStatement)stmt));
    }

    public StyledString text(DropIndexStatement stmt) {
        return this.styling("DROP INDEX ", stmt.getIndex().getName());
    }

    public StyledString text(AlterTableStatement stmt) {
        return this.styling("ALTER TABLE ", this.combineKeyspaceTableName((CqlStatement)stmt));
    }

    public StyledString text(AlterKeyspaceStatement stmt) {
        return this.styling("ALTER KEYSPACE ", stmt.getKeyspace().getName());
    }

    public StyledString text(GrantStatement stmt) {
        return this.styling("GRANT TO ", stmt.getUserOrRole().getName());
    }

    public StyledString text(RevokeStatement stmt) {
        return this.styling("REVOKE FROM ", stmt.getUserOrRole().getName());
    }

    public StyledString text(ListPermissionsStatement stmt) {
        return this.styling("LIST PERMISSION ", stmt.getUserOrRole().getName());
    }

    public StyledString text(CreateUserStatement stmt) {
        return this.styling("CREATE USER ", stmt.getUser().getName());
    }

    public StyledString text(AlterUserStatement stmt) {
        return this.styling("ALTER USER ", stmt.getUser().getName());
    }

    public StyledString text(DropUserStatement stmt) {
        return this.styling("DROP USER ", stmt.getUser().getName());
    }

    public StyledString text(ListUsersStatement stmt) {
        return this.styling("LIST USER", "");
    }

    public StyledString text(CreateRoleStatement stmt) {
        return this.styling("CREATE ROLE ", stmt.getUserOrRole().getName());
    }

    public StyledString text(AlterRoleStatement stmt) {
        return this.styling("ALTER ROLE ", stmt.getUserOrRole().getName());
    }

    public StyledString text(DropRoleStatement stmt) {
        return this.styling("DROP ROLE ", stmt.getUserOrRole().getName());
    }

    public StyledString text(ListRolesStatement stmt) {
        return this.styling("LIST ROLES ", stmt.getUserOrRole().getName());
    }

    public StyledString text(CreateTriggerStatement stmt) {
        return this.styling("CREATE TRIGGER ", stmt.getTrigger().getName());
    }

    public StyledString text(DropTriggerStatement stmt) {
        return this.styling("DROP TRIGGER ", stmt.getTrigger().getName());
    }

    public StyledString text(AlterTypeStatement stmt) {
        return this.styling("ALTER TYPE ", stmt.getUserType().getName());
    }

    public StyledString text(CreateTypeStatement stmt) {
        return this.styling("CREATE TYPE ", stmt.getUserType().getName());
    }

    public StyledString text(CreateFunctionStatement stmt) {
        return this.styling("CREATE FUNCTION ", stmt.getFunction().getName());
    }

    public StyledString text(CreateAggregateFunctionStatement stmt) {
        return this.styling("CREATE AGGREGATE ", stmt.getFunction().getName());
    }

    public StyledString text(DropFunctionStatement stmt) {
        if (stmt.isAggregate()) {
            return this.styling("DROP AGGREGATE ", stmt.getFunction().getName());
        }
        return this.styling("DROP FUNCTION ", stmt.getFunction().getName());
    }

    public StyledString text(DropTypeStatement stmt) {
        return this.styling("DROP TYPE ", stmt.getUserType().getName());
    }
}

