/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.providers;

import com.datastax.devcenter.cql.ui.jobs.MetadataSelectStatement;
import com.datastax.devcenter.cql.ui.providers.cell.CqlResultsCellWrapper;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class CqlResultsContentProvider
implements IStructuredContentProvider {
    private ResultSet resultSet;
    private ResultSet metadataResultSet;
    private Collection<Object> resultSetCollection;
    private int numberOfColumns;
    private int numberOfRows;
    private static final Pattern TOJSON_PATTERN = Pattern.compile("system.tojson(.*)");

    public Object[] getElements(Object inputElement) {
        return this.resultSetCollection.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            return;
        }
        ResultSet[] resultSets = (ResultSet[])newInput;
        this.resultSet = resultSets[0];
        this.metadataResultSet = resultSets[1];
        this.resultSetCollection = new ArrayList<Object>();
        List columnDefs = this.resultSet.getColumnDefinitions().asList();
        Iterator rowIterator = this.resultSet.iterator();
        Iterator metadataIterator = this.metadataResultSet != null ? this.metadataResultSet.iterator() : null;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            Row metadataRow = null;
            if (metadataIterator != null && metadataIterator.hasNext()) {
                metadataRow = (Row)metadataIterator.next();
            }
            ++this.numberOfRows;
            this.resultSetCollection.add(this.getColumnValues(row, metadataRow, columnDefs));
        }
    }

    public Object[] getColumnValues(Row row, Row metadataRow, List<ColumnDefinitions.Definition> definitionsList) {
        Object[] columnValues = new Object[this.numberOfColumns];
        int index = 0;
        while (index < this.numberOfColumns) {
            ColumnDefinitions.Definition definition = definitionsList.get(index);
            Integer ttl = this.getTtlValue(metadataRow, definition);
            Long timestamp = this.getTimestampValue(metadataRow, definition);
            DataType type = definition.getType();
            Object cell = this.getColumnValue(row, index, type.getName());
            boolean isToJson = TOJSON_PATTERN.matcher(definition.getName()).matches();
            columnValues[index] = new CqlResultsCellWrapper(cell, type, ttl, timestamp, isToJson);
            ++index;
        }
        return columnValues;
    }

    public Object getColumnValue(Row row, int columnIndex, DataType.Name typeName) {
        if (row.isNull(columnIndex)) {
            return null;
        }
        switch (typeName) {
            case UUID: {
                return row.getUUID(columnIndex);
            }
            case ASCII: {
                return row.getString(columnIndex);
            }
            case BIGINT: {
                return row.getLong(columnIndex);
            }
            case BLOB: {
                return row.getBytes(columnIndex);
            }
            case BOOLEAN: {
                return row.getBool(columnIndex);
            }
            case DECIMAL: {
                return row.getDecimal(columnIndex);
            }
            case DOUBLE: {
                return row.getDouble(columnIndex);
            }
            case FLOAT: {
                return Float.valueOf(row.getFloat(columnIndex));
            }
            case INT: {
                return row.getInt(columnIndex);
            }
            case SMALLINT: {
                return row.getShort(columnIndex);
            }
            case TINYINT: {
                return row.getByte(columnIndex);
            }
            case TEXT: {
                return row.getString(columnIndex);
            }
            case INET: {
                return row.getInet(columnIndex);
            }
            case TIMESTAMP: {
                return row.getTimestamp(columnIndex);
            }
            case TIME: {
                return this.nanosToTime(row.getTime(columnIndex));
            }
            case DATE: {
                return row.getDate(columnIndex);
            }
            case VARINT: {
                return row.getVarint(columnIndex);
            }
            case TIMEUUID: {
                return row.getUUID(columnIndex);
            }
            case COUNTER: {
                return row.getLong(columnIndex);
            }
            case VARCHAR: {
                return row.getString(columnIndex);
            }
            case LIST: {
                return row.getList(columnIndex, Object.class);
            }
            case SET: {
                return row.getSet(columnIndex, Object.class);
            }
            case MAP: {
                return row.getMap(columnIndex, Object.class, Object.class);
            }
            case UDT: {
                return row.getUDTValue(columnIndex);
            }
            case TUPLE: {
                return row.getTupleValue(columnIndex);
            }
        }
        return row.getString(columnIndex);
    }

    private Object nanosToTime(long nanosSinceMidnight) {
        long millis = TimeUnit.NANOSECONDS.toMillis(nanosSinceMidnight);
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String hourMinSec = dateFormat.format(millis);
        nanosSinceMidnight -= TimeUnit.MILLISECONDS.toNanos(millis);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
        return String.format("%s.%09d", hourMinSec, nanosSinceMidnight += TimeUnit.MILLISECONDS.toNanos(millis -= TimeUnit.SECONDS.toMillis(seconds)));
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public ResultSet getMetadataResultSet() {
        return this.metadataResultSet;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    private Integer getTtlValue(Row row, ColumnDefinitions.Definition definition) {
        Integer ttl = Integer.MIN_VALUE;
        if (row == null) {
            return ttl;
        }
        String ttlColumnName = MetadataSelectStatement.geTtlName(definition.getName());
        if (row.getColumnDefinitions().contains(ttlColumnName)) {
            ttl = row.isNull(ttlColumnName) ? null : Integer.valueOf(row.getInt(ttlColumnName));
        }
        return ttl;
    }

    private Long getTimestampValue(Row row, ColumnDefinitions.Definition definition) {
        Long timestamp = Long.MIN_VALUE;
        if (row == null) {
            return timestamp;
        }
        String tsColumnName = MetadataSelectStatement.getTimestampName(definition.getName());
        if (row.getColumnDefinitions().contains(tsColumnName)) {
            timestamp = row.isNull(tsColumnName) ? null : Long.valueOf(row.getLong(tsColumnName));
        }
        return timestamp;
    }
}

