/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.providers;

import com.datastax.devcenter.cql.ui.providers.cell.CqlResultsCellWrapper;
import com.datastax.driver.core.utils.Bytes;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ColumnLabelProvider;

public class CqlResultsLabelProvider
extends ColumnLabelProvider {
    private static final String BEGIN_QUOTE = "<<";
    private static final String END_QUOTE = ">>";
    private static final int MAX_STRING_SIZE = 256;
    private final int index;

    public CqlResultsLabelProvider(int index) {
        this.index = index;
    }

    private String buildResult(String result) {
        return BEGIN_QUOTE + result + END_QUOTE;
    }

    private String stripNewlines(String result) {
        return result.replace('\n', ' ');
    }

    public String getText(Object element) {
        try {
            Object[] objectArray = (Object[])element;
            Object object = ((CqlResultsCellWrapper)objectArray[this.index]).getCell();
            if (object == null) {
                return this.buildResult("null");
            }
            if (object instanceof Set) {
                Set set = (Set)object;
                if (set.toString().length() <= 256) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("{");
                    Iterator i = set.iterator();
                    while (i.hasNext()) {
                        sb.append(i.next());
                        if (!i.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("}");
                    return this.stripNewlines(sb.toString());
                }
                return this.buildResult("Set (" + set.size() + ")");
            }
            if (object instanceof List) {
                List list = (List)object;
                if (list.toString().length() <= 256) {
                    return this.stripNewlines(list.toString());
                }
                return this.buildResult("List (" + list.size() + ")");
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                if (map.toString().length() <= 256) {
                    return this.stripNewlines(map.toString());
                }
                return this.buildResult("Map (" + map.size() + ")");
            }
            if (object instanceof ByteBuffer) {
                ByteBuffer bb = (ByteBuffer)object;
                String hexStr = Bytes.toHexString((ByteBuffer)bb);
                if (hexStr.length() <= 256) {
                    return hexStr;
                }
                return this.buildResult("Blob (" + bb.capacity() + ")");
            }
            if (object instanceof InetAddress) {
                return InetAddresses.toAddrString((InetAddress)((InetAddress)object));
            }
            return this.stripNewlines(StringUtils.substring((String)object.toString(), (int)0, (int)256));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<<Value Error>>";
        }
    }
}

