/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.providers;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.QueryTrace;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TraceInfoContentProvider
implements ITreeContentProvider {
    private List<InetAddress> nodeList;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ExecutionInfo) {
            this.nodeList = new ArrayList<InetAddress>();
            QueryTrace queryTrace = ((ExecutionInfo)newInput).getQueryTrace();
            for (QueryTrace.Event event : queryTrace.getEvents()) {
                InetAddress source = event.getSource();
                if (this.nodeList.contains(source)) continue;
                this.nodeList.add(source);
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ExecutionInfo) {
            Object[] objects = new Object[]{((ExecutionInfo)inputElement).getQueryTrace()};
            return objects;
        }
        if (inputElement instanceof QueryTrace) {
            return this.nodeList.toArray();
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof QueryTrace) {
            return this.nodeList.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof QueryTrace;
    }
}

