/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.providers;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.ResultSet;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TraceTableContentProvider
implements IStructuredContentProvider {
    public static final int MICROS_IN_A_MILLISECOND = 1000;
    public static final int TRACE_TABLE_COL_DESC = 0;
    public static final int TRACE_TABLE_COL_TIMESTAMP = 1;
    public static final int TRACE_TABLE_COL_SOURCE = 2;
    public static final int TRACE_TABLE_COL_SOURCE_ROLE = 3;
    public static final int TRACE_TABLE_COL_ELAPSED = 4;
    public static final int TRACE_TABLE_COL_THREAD = 5;
    public static final int NUM_COLUMNS = 6;
    private Collection<Object> resultSetCollection;
    private InetAddress coordinatorNode;

    public Object[] getElements(Object inputElement) {
        return this.resultSetCollection.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            return;
        }
        ResultSet resultSet = (ResultSet)newInput;
        this.resultSetCollection = new ArrayList<Object>();
        ExecutionInfo executionInfo = resultSet.getExecutionInfo();
        QueryTrace queryTrace = executionInfo.getQueryTrace();
        this.setCoordinatorNode(queryTrace.getCoordinator());
        this.addToResults("Execute CQL3 query", this.timestampInMicros(queryTrace.getStartedAt()), SourceNodeRole.COORDINATOR, queryTrace.getCoordinator(), 0, "");
        for (QueryTrace.Event event : queryTrace.getEvents()) {
            this.addToResults(event);
        }
        long endTimeMicroseconds = this.timestampInMicros(queryTrace.getStartedAt()) + (long)queryTrace.getDurationMicros();
        this.addToResults("Request complete", endTimeMicroseconds, SourceNodeRole.COORDINATOR, queryTrace.getCoordinator(), queryTrace.getDurationMicros(), "");
    }

    private void addToResults(QueryTrace.Event event) {
        this.addToResults(event.getDescription(), this.timestampInMicros(event.getTimestamp()), this.getSourceNodeRole(event), event.getSource(), event.getSourceElapsedMicros(), event.getThreadName());
    }

    private void addToResults(String desc, long timestampInMicros, SourceNodeRole sourceNodeRole, InetAddress sourceNode, int elapsed, String threadName) {
        Object[] tempObjectArray = new Object[]{desc, timestampInMicros, sourceNode, sourceNodeRole, elapsed, threadName};
        this.resultSetCollection.add(tempObjectArray);
    }

    private long timestampInMicros(long timestamp) {
        return timestamp * 1000L;
    }

    public SourceNodeRole getSourceNodeRole(QueryTrace.Event event) {
        if (event.getSource().equals(this.coordinatorNode)) {
            if (this.activityIsForCoordinator(event.getDescription())) {
                return SourceNodeRole.COORDINATOR;
            }
            return SourceNodeRole.BOTH;
        }
        return SourceNodeRole.REPLICA;
    }

    public boolean activityIsForCoordinator(String activity) {
        String[] coordinatorActivities;
        String[] stringArray = coordinatorActivities = new String[]{"Parsing ", "Preparing statement", "Determining replicas", "Sending message", "Message received", "Enqueuing request", "Processing response"};
        int n = coordinatorActivities.length;
        int n2 = 0;
        while (n2 < n) {
            String coordinatorActivity = stringArray[n2];
            if (activity.startsWith(coordinatorActivity)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setCoordinatorNode(InetAddress node) {
        this.coordinatorNode = node;
    }

    public static enum SourceNodeRole {
        COORDINATOR,
        REPLICA,
        BOTH;

    }
}

