/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.providers.cell;

import com.datastax.devcenter.common.utils.IconUtility;
import com.datastax.devcenter.cql.ui.CqlActivator;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;

public class CheckboxBeanPropertyCellLabelProvider
extends OwnerDrawLabelProvider {
    private final Image checked = IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/checked.png").createImage();
    private final Image unchecked = IconUtility.getImageDescriptor((Plugin)CqlActivator.getDefault(), (String)"icons/unchecked.png").createImage();
    private final IBeanValueProperty property;
    private final IConverter converter;
    private String toolTipText;

    public CheckboxBeanPropertyCellLabelProvider(IBeanValueProperty property) {
        this(property, null);
    }

    public CheckboxBeanPropertyCellLabelProvider(IBeanValueProperty property, IConverter converter) {
        this.property = property;
        this.converter = converter;
    }

    protected Object getPropertyValue(Object element) {
        Object value = this.property.getValue(element);
        if (this.converter != null) {
            value = this.converter.convert(value);
        }
        return value;
    }

    protected Image getImage(Object element) {
        Boolean value = (Boolean)this.getPropertyValue(element);
        if (value != null && value.booleanValue()) {
            return this.checked;
        }
        return this.unchecked;
    }

    public String getToolTipText(Object element) {
        return this.toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }

    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
        Image img = this.getImage(element);
        if (img != null) {
            Rectangle bounds = ((TableItem)event.item).getBounds(event.index);
            Rectangle imgBounds = img.getBounds();
            bounds.width /= 2;
            bounds.width -= imgBounds.width / 2;
            bounds.height /= 2;
            bounds.height -= imgBounds.height / 2;
            int x = bounds.width > 0 ? bounds.x + bounds.width : bounds.x;
            int y = bounds.height > 0 ? bounds.y + bounds.height : bounds.y;
            event.gc.drawImage(img, x, y);
        }
    }

    protected void erase(Event event, Object element) {
    }

    public void dispose() {
        super.dispose();
        this.checked.dispose();
        this.unchecked.dispose();
    }
}

