/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.providers.cell_details_tree;

import com.datastax.devcenter.cql.ui.providers.cell_details_tree.CellDetailsContentHolder;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ResultSet;
import java.util.List;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.TableItem;

public class CellDetailsTreeStyledCellLabelProvider
extends StyledCellLabelProvider {
    public void update(ViewerCell viewerCell) {
        Object element = viewerCell.getElement();
        if (!(element instanceof CellDetailsContentHolder)) {
            return;
        }
        CellDetailsContentHolder cellDetailsContentHolder = (CellDetailsContentHolder)element;
        TableItem tableItem = cellDetailsContentHolder.getTableItem();
        int columnIndex = cellDetailsContentHolder.getColumnIndex();
        cellDetailsContentHolder.getRowIndex();
        ResultSet resultSet = cellDetailsContentHolder.getResultSet();
        Object dataObject = tableItem.getData();
        Object[] objectArray = (Object[])dataObject;
        Object selectedObject = objectArray[columnIndex];
        ColumnDefinitions columnDefinitions = resultSet.getColumnDefinitions();
        List definitionsList = columnDefinitions.asList();
        ColumnDefinitions.Definition definition = (ColumnDefinitions.Definition)definitionsList.get(columnIndex);
        String columnName = definition.getName();
        StyledString labelStyledString = this.createTextCellStyledString(columnName, selectedObject);
        viewerCell.setText(labelStyledString.toString());
        viewerCell.setStyleRanges(labelStyledString.getStyleRanges());
        super.update(viewerCell);
    }

    public StyledString createTextCellStyledString(String columnName, Object objectFromCell) {
        String displayStr;
        StyledString labelStyledString = new StyledString();
        labelStyledString.append(columnName);
        labelStyledString.append(" : ");
        try {
            displayStr = objectFromCell == null ? "<<null>>" : objectFromCell.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            displayStr = "<<Value Error>>";
        }
        labelStyledString.append(displayStr);
        return labelStyledString;
    }
}

