/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.providers.editing_support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Widget;

public class BeanPropertyEditingSupport
extends ObservableValueEditingSupport {
    protected final ColumnViewer viewer;
    protected final DataBindingContext dbc;
    protected final CellEditor cellEditor;
    protected final IBeanValueProperty modelProperty;
    protected final IWidgetValueProperty widgetProperty;
    protected IConverter targetToModelConverter;
    protected IConverter modelToTargetConverter;
    protected IValidator afterGetValidator;
    protected IValidator afterConvertValidator;
    protected final List<IChangeListener> modelChangeListeners = new ArrayList<IChangeListener>();

    public BeanPropertyEditingSupport(ColumnViewer viewer, DataBindingContext dbc, CellEditor cellEditor, IWidgetValueProperty widgetProperty, IBeanValueProperty modelProperty) {
        super(viewer, dbc);
        this.viewer = viewer;
        this.dbc = dbc;
        this.cellEditor = cellEditor;
        this.modelProperty = modelProperty;
        this.widgetProperty = widgetProperty;
    }

    public void setTargetToModelConverter(IConverter targetToModelConverter) {
        this.targetToModelConverter = targetToModelConverter;
    }

    public void setModelToTargetConverter(IConverter modelToTargetConverter) {
        this.modelToTargetConverter = modelToTargetConverter;
    }

    public void setAfterGetValidator(IValidator afterGetValidator) {
        this.afterGetValidator = afterGetValidator;
    }

    public void setAfterConvertValidator(IValidator afterConvertValidator) {
        this.afterConvertValidator = afterConvertValidator;
    }

    public void addModelChangeListener(IChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
        return this.widgetProperty.observe((Widget)cellEditor.getControl());
    }

    protected IObservableValue doCreateElementObservable(Object element, final ViewerCell cell) {
        IObservableValue property = this.modelProperty.observe(element);
        property.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                CellLabelProvider labelProvider = BeanPropertyEditingSupport.this.viewer.getLabelProvider(cell.getColumnIndex());
                labelProvider.update(cell);
            }
        });
        for (IChangeListener listener : this.modelChangeListeners) {
            property.addChangeListener(listener);
        }
        return property;
    }

    protected Binding createBinding(IObservableValue target, IObservableValue model) {
        return this.dbc.bindValue(target, model, this.getTargetToModelStrategy(), this.getModelToTargetStrategy());
    }

    protected UpdateValueStrategy getTargetToModelStrategy() {
        UpdateValueStrategy strategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        strategy.setConverter(this.targetToModelConverter);
        strategy.setAfterGetValidator(this.afterGetValidator);
        strategy.setAfterConvertValidator(this.afterConvertValidator);
        return strategy;
    }

    protected UpdateValueStrategy getModelToTargetStrategy() {
        UpdateValueStrategy strategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        strategy.setConverter(this.modelToTargetConverter);
        return strategy;
    }
}

