/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.providers.editing_support;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class CqlTextEditingSupport
extends EditingSupport {
    private static final int MAX_STRING_SIZE = 128;
    private final TableViewer tableViewer;
    private final int columnIndex;

    public CqlTextEditingSupport(TableViewer tableViewer, int columnIndex) {
        super((ColumnViewer)tableViewer);
        this.tableViewer = tableViewer;
        this.columnIndex = columnIndex;
    }

    protected CellEditor getCellEditor(Object element) {
        return new TextCellEditor((Composite)this.tableViewer.getTable());
    }

    protected boolean canEdit(Object element) {
        return false;
    }

    protected Object getValue(Object element) {
        Object[] objectArray = (Object[])element;
        Object selectedObject = objectArray[this.columnIndex];
        try {
            if (!(selectedObject instanceof String)) {
                return StringUtils.substring((String)String.valueOf(selectedObject), (int)0, (int)128);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<<Value Error>>";
        }
        return selectedObject;
    }

    protected void setValue(Object element, Object value) {
        Object[] objectArray = (Object[])element;
        objectArray[this.columnIndex] = value;
        this.tableViewer.update(element, null);
    }
}

