/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.quickfix;

import com.datastax.devcenter.common.metrics.Metrics;
import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.CqlContextProvider;
import com.datastax.devcenter.cql.cql.ColumnDef;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.CreateIndexStatement;
import com.datastax.devcenter.cql.cql.CreateKeyspaceStatement;
import com.datastax.devcenter.cql.cql.CreateRoleStatement;
import com.datastax.devcenter.cql.cql.CreateTableStatement;
import com.datastax.devcenter.cql.cql.CreateTypeStatement;
import com.datastax.devcenter.cql.cql.CreateUserStatement;
import com.datastax.devcenter.cql.cql.DropFunctionStatement;
import com.datastax.devcenter.cql.cql.DropIndexStatement;
import com.datastax.devcenter.cql.cql.DropKeyspaceStatement;
import com.datastax.devcenter.cql.cql.DropRoleStatement;
import com.datastax.devcenter.cql.cql.DropTableStatement;
import com.datastax.devcenter.cql.cql.DropTypeStatement;
import com.datastax.devcenter.cql.cql.DropUserStatement;
import com.datastax.devcenter.cql.cql.InsertStatement;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.MapEntry;
import com.datastax.devcenter.cql.cql.Property;
import com.datastax.devcenter.cql.cql.StatementsWithProperties;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.TypoStatement;
import com.datastax.devcenter.cql.util.LevenshteinDistance;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.util.StrDistance;
import com.datastax.devcenter.cql.util.StrDistanceList;
import com.datastax.devcenter.schema.AbstractSchemaElement;
import com.datastax.devcenter.schema.BuiltInFunctionsRegistry;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Keyword;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.StatementIndexMap;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.User;
import com.datastax.devcenter.schema.options.ReplicationStrategy;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class CqlQuickfixProvider
extends DefaultQuickfixProvider {
    @Inject
    CqlContextProvider cqlContextProvider;

    CqlQuickfixProvider() {
    }

    private CqlContext getCqlContext(Issue issue) {
        String fileURI = issue.getUriToProblem().toString().replaceFirst("\\.cql#.*", ".cql");
        return this.cqlContextProvider.get(fileURI);
    }

    @Fix(value="caseInsensitiveName")
    public void caseInsensitiveKeyspaceName(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add double quote", "Add double quote", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                String str = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), String.valueOf('\"') + str + '\"');
                CqlQuickfixProvider.this.emitQuickFixMetric(issue);
            }
        });
    }

    @Fix(value="INVALID_NAME_BECAUSE_IT_CONTAINS_ESCAPED_QUOTE")
    public void invalidColumnNameContainingEscapedQuote(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove quote", "Remove quote", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                String str = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                str = str.replace("\\\"", "");
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), str);
                CqlQuickfixProvider.this.emitQuickFixMetric(issue);
            }
        });
    }

    @Fix(value="USE_UNRESERVED_KEYWORD")
    public void quoteUnreservedKeyword(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add double quote", "Add double quotes to reserved keywords", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                String str = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), String.valueOf('\"') + str + '\"');
                CqlQuickfixProvider.this.emitQuickFixMetric(issue);
            }
        });
    }

    @Fix(value="partitionKeyError")
    public void partitionKeyNotFirst(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Move partition key to the first position", "Move partition key to the first position in the PRIMARY KEY list", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                IXtextDocument doc = context.getXtextDocument();
                String errorKey = doc.get(issue.getOffset().intValue(), issue.getLength().intValue());
                int errorStartPos = issue.getOffset();
                int errorEndPos = issue.getOffset() + issue.getLength();
                ColumnDef columnDef = (ColumnDef)element;
                EList pkdefs = columnDef.getPrimaryKeyDefinitions();
                ICompositeNode firstPkdefInode = NodeModelUtils.getNode((EObject)((EObject)pkdefs.get(0)));
                int strStart = firstPkdefInode.getOffset();
                ICompositeNode lastPkdefInode = NodeModelUtils.getNode((EObject)((EObject)pkdefs.get(pkdefs.size() - 1)));
                int strEnd = lastPkdefInode.getOffset() + lastPkdefInode.getLength();
                int strLength = strEnd - strStart;
                String errorStr = doc.get(strStart, strLength);
                String seg1 = errorStr.substring(0, errorStartPos - strStart);
                String seg2 = errorStr.substring(errorEndPos - strStart, strEnd - strStart);
                String ss = seg1.replaceAll(",[ ]*$", "");
                String tmpStr = String.valueOf(errorKey) + ", " + ss + seg2;
                doc.replace(strStart, strLength, tmpStr);
                CqlQuickfixProvider.this.emitQuickFixMetric(issue);
            }
        });
    }

    @Fix(value="partitionKeyError")
    public void partitionKeyStripParen(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Strip parentheses", "Change partition key to clustering key", null, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                IXtextDocument doc = context.getXtextDocument();
                String errorKey = doc.get(issue.getOffset().intValue(), issue.getLength().intValue());
                doc.replace(issue.getOffset().intValue(), issue.getLength().intValue(), errorKey.substring(1, errorKey.length() - 1));
                CqlQuickfixProvider.this.emitQuickFixMetric(issue);
            }
        });
    }

    @Fix(value="KeyspaceExist")
    public void addIfNotExiststoCreateKeySpace(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null && stmt instanceof CreateKeyspaceStatement && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0)) {
            acceptor.accept(issue, "Add IF NOT EXISTS to this statement", "", null, new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                    if (stmt instanceof CreateKeyspaceStatement) {
                        CreateKeyspaceStatement createKeyspaceStmt = (CreateKeyspaceStatement)stmt;
                        createKeyspaceStmt.setIfNotExists(true);
                    }
                }
            });
        }
    }

    @Fix(value="KeyspaceNotExist")
    public void addIfExistsOrDIfferentKeyspaceName(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null) {
            if (stmt instanceof DropKeyspaceStatement && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0)) {
                acceptor.accept(issue, "Add IF EXISTS to this statement", "", null, new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                        if (stmt instanceof DropKeyspaceStatement) {
                            DropKeyspaceStatement dropKeyspaceStatement = (DropKeyspaceStatement)stmt;
                            dropKeyspaceStatement.setIfExists(true);
                        }
                    }
                });
            }
            int idx = statementIndexMap.getStatementIndex(stmt);
            Schema schema = cqlContext.getSchema(idx);
            this.proposeSimilarExistingElements(issue, acceptor, schema.getKeyspaces(), true, false);
        }
    }

    @Fix(value="TableExist")
    public void addIfNotExiststoCreateTable(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null && stmt instanceof CreateTableStatement && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0)) {
            acceptor.accept(issue, "Add IF NOT EXISTS to this statement", "", null, new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                    if (stmt instanceof CreateTableStatement) {
                        CreateTableStatement createTableStmt = (CreateTableStatement)stmt;
                        createTableStmt.setIfNotExists(true);
                    }
                }
            });
        }
    }

    @Fix(value="TableNotExist")
    public void addIfExistsOrDifferentTableName(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null) {
            Keyspace ksMeta;
            int idx;
            Schema schema;
            Keyspace currentKeyspace;
            if (stmt instanceof DropTableStatement && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0)) {
                acceptor.accept(issue, "Add IF EXISTS to this statement", "", null, new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                        if (stmt instanceof DropTableStatement) {
                            DropTableStatement dropTableStatement = (DropTableStatement)stmt;
                            dropTableStatement.setIfExists(true);
                        }
                    }
                });
            }
            if ((currentKeyspace = (schema = cqlContext.getSchema(idx = statementIndexMap.getStatementIndex(stmt))).getCurrentKeyspace()) == null) {
                return;
            }
            List tables = currentKeyspace.getTables();
            KeyspaceEntity keyspace = ModelUtil.getKeyspace((CqlStatement)stmt);
            if (keyspace != null && (ksMeta = schema.getKeyspace(keyspace.getName())) != null) {
                tables = ksMeta.getTables();
            }
            this.proposeSimilarExistingElements(issue, acceptor, tables, true, false);
        }
    }

    @Fix(value="TypeExist")
    public void addIfNotExiststoCreateType(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null && stmt instanceof CreateTypeStatement && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_1_0)) {
            acceptor.accept(issue, "Add IF NOT EXISTS to this statement", "", null, new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                    if (stmt instanceof CreateTypeStatement) {
                        CreateTypeStatement createTypeStmt = (CreateTypeStatement)stmt;
                        createTypeStmt.setIfNotExists(true);
                    }
                }
            });
        }
    }

    @Fix(value="TypeNotExist")
    public void addIfExistsOrDifferentTypeName(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null) {
            Keyspace ksMeta;
            int idx;
            Schema schema;
            Keyspace currentKeyspace;
            if (stmt instanceof DropTypeStatement && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_1_0)) {
                acceptor.accept(issue, "Add IF EXISTS to this statement", "", null, new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                        if (stmt instanceof DropTypeStatement) {
                            DropTypeStatement dropTypeStatement = (DropTypeStatement)stmt;
                            dropTypeStatement.setIfExists(true);
                        }
                    }
                });
            }
            if ((currentKeyspace = (schema = cqlContext.getSchema(idx = statementIndexMap.getStatementIndex(stmt))).getCurrentKeyspace()) == null) {
                return;
            }
            List userTypes = currentKeyspace.getUserTypes();
            KeyspaceEntity keyspace = ModelUtil.getKeyspace((CqlStatement)stmt);
            if (keyspace != null && (ksMeta = schema.getKeyspace(keyspace.getName())) != null) {
                userTypes = ksMeta.getUserTypes();
            }
            this.proposeSimilarExistingElements(issue, acceptor, userTypes, true, false);
        }
    }

    @Fix(value="ColumnNotExist")
    public void proposeDifferentColumnName(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null) {
            int idx = statementIndexMap.getStatementIndex(stmt);
            Schema schema = cqlContext.getSchema(idx);
            KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace((CqlStatement)stmt);
            TableEntity tableEntity = ModelUtil.getTable((CqlStatement)stmt);
            if (tableEntity != null && schema.getTable(keyspaceEntity, tableEntity) != null) {
                Table tableMeta = schema.getTable(keyspaceEntity, tableEntity);
                this.proposeSimilarExistingElements(issue, acceptor, tableMeta.getColumns(), true, this.isColumnFromJSONInsert(stmt));
            }
        }
    }

    private boolean isColumnFromJSONInsert(CqlStatement stmt) {
        InsertStatement insert;
        boolean columnFromJSON = false;
        if (stmt instanceof InsertStatement && (insert = (InsertStatement)stmt).getJsonInsertPart() != null) {
            columnFromJSON = true;
        }
        return columnFromJSON;
    }

    @Fix(value="IndexExist")
    public void addIfNotExiststoCreateIndex(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null && stmt instanceof CreateIndexStatement && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0)) {
            acceptor.accept(issue, "Add IF NOT EXISTS to this statement", "", null, new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                    if (stmt instanceof CreateIndexStatement) {
                        CreateIndexStatement createIndexStatement = (CreateIndexStatement)stmt;
                        createIndexStatement.setIfNotExists(true);
                    }
                }
            });
        }
    }

    @Fix(value="IndexNotExist")
    public void findAlterIndex(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null) {
            if (stmt instanceof DropIndexStatement && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0)) {
                acceptor.accept(issue, "Add IF EXISTS to this statement", "", null, new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                        if (stmt instanceof DropIndexStatement) {
                            DropIndexStatement dropIndexStatement = (DropIndexStatement)stmt;
                            dropIndexStatement.setIfExists(true);
                        }
                    }
                });
            }
            int idx = statementIndexMap.getStatementIndex(stmt);
            Schema schema = cqlContext.getSchema(idx);
            this.proposeSimilarExistingElements(issue, acceptor, (Collection<? extends AbstractSchemaElement>)schema.getIndices());
        }
    }

    @Fix(value="TriggerNotExist")
    public void findAlterTrigger(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0)) {
            int idx = statementIndexMap.getStatementIndex(stmt);
            Schema schema = cqlContext.getSchema(idx);
            this.proposeSimilarExistingElements(issue, acceptor, schema.getTriggers());
        }
    }

    @Fix(value="USER_ALREADY_EXISTS")
    public void addIfNotExiststoCreateUser(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null && stmt instanceof CreateUserStatement && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_9)) {
            acceptor.accept(issue, "Add IF NOT EXISTS to this statement", "", null, new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                    if (stmt instanceof CreateUserStatement) {
                        CreateUserStatement createStatement = (CreateUserStatement)stmt;
                        createStatement.setIfNotExists(true);
                    }
                }
            });
        }
    }

    @Fix(value="USER_OR_ROLE_ALREADY_EXISTS")
    public void addIfNotExiststoCreateRole(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null && stmt instanceof CreateRoleStatement && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_2_0)) {
            acceptor.accept(issue, "Add IF NOT EXISTS to this statement", "", null, new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                    if (stmt instanceof CreateRoleStatement) {
                        CreateRoleStatement createStatement = (CreateRoleStatement)stmt;
                        createStatement.setIfNotExists(true);
                    }
                }
            });
        }
    }

    @Fix(value="USER_DOES_NOT_EXIST")
    public void findAlterUsername(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null) {
            if (stmt instanceof DropUserStatement && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_9)) {
                acceptor.accept(issue, "Add IF EXISTS to this statement", "", null, new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                        if (stmt instanceof DropUserStatement) {
                            DropUserStatement dropStatement = (DropUserStatement)stmt;
                            dropStatement.setIfExists(true);
                        }
                    }
                });
            }
            int idx = statementIndexMap.getStatementIndex(stmt);
            Schema schema = cqlContext.getSchema(idx);
            ArrayList<User> lowercaseUsers = new ArrayList<User>();
            for (User user : schema.getUsers()) {
                if (!user.getName().toLowerCase().equals(user.getName())) continue;
                lowercaseUsers.add(user);
            }
            this.proposeSimilarExistingElements(issue, acceptor, lowercaseUsers);
        }
    }

    @Fix(value="USER_OR_ROLE_DOES_NOT_EXIST")
    public void findUserOrRole(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null) {
            if (stmt instanceof DropRoleStatement && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_2_0)) {
                acceptor.accept(issue, "Add IF EXISTS to this statement", "", null, new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                        if (stmt instanceof DropRoleStatement) {
                            DropRoleStatement dropStatement = (DropRoleStatement)stmt;
                            dropStatement.setIfExists(true);
                        }
                    }
                });
            }
            int idx = statementIndexMap.getStatementIndex(stmt);
            Schema schema = cqlContext.getSchema(idx);
            this.proposeSimilarExistingElements(issue, acceptor, schema.getUsers(), true, false);
        }
    }

    private void proposeSimilarExistingElements(Issue issue, IssueResolutionAcceptor acceptor, Collection<? extends AbstractSchemaElement> collection) {
        this.proposeSimilarExistingElements(issue, acceptor, collection, false, false);
    }

    private void proposeSimilarExistingElements(final Issue issue, IssueResolutionAcceptor acceptor, Collection<? extends AbstractSchemaElement> collection, final boolean escapeProposedName, final boolean doubleQuoteProposedName) {
        String errorString = issue.getData()[0];
        StrDistanceList strDistanceList = new StrDistanceList(errorString);
        for (AbstractSchemaElement abstractSchemaElement : collection) {
            strDistanceList.addStr(abstractSchemaElement.getName());
        }
        strDistanceList.sortList();
        for (final StrDistance strDistance : strDistanceList.getInstances()) {
            acceptor.accept(issue, "change to " + strDistance.getName(), "change " + errorString + " to " + strDistance.getName(), null, new IModification(){

                public void apply(IModificationContext context) throws Exception {
                    String proposedName = strDistance.getName();
                    if (escapeProposedName) {
                        proposedName = ModelUtil.escapeName((String)proposedName);
                    }
                    if (doubleQuoteProposedName) {
                        proposedName = ModelUtil.doubleQuote((String)proposedName);
                    }
                    IXtextDocument doc = context.getXtextDocument();
                    doc.replace(issue.getOffset().intValue(), issue.getLength().intValue(), proposedName);
                    CqlQuickfixProvider.this.emitQuickFixMetric(issue);
                }
            });
        }
    }

    @Fix(value="TOKEN_ARGS_DISMATCH_PARITION_KEY")
    public void matchTokenArgsToPartitionKey2(final Issue issue, IssueResolutionAcceptor acceptor) {
        String[] pks = issue.getData();
        String correctShow = pks[0];
        String correctEnter = ModelUtil.escapeName((String)pks[0]);
        int i = 1;
        while (i < pks.length) {
            correctShow = String.valueOf(correctShow) + ", " + pks[i];
            correctEnter = String.valueOf(correctEnter) + ", " + ModelUtil.escapeName((String)pks[i]);
            ++i;
        }
        String show = "token(" + correctShow + ")";
        final String enter = correctEnter;
        acceptor.accept(issue, "change to " + show, "change to partition key " + show, null, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                IXtextDocument doc = context.getXtextDocument();
                doc.replace(issue.getOffset().intValue(), issue.getLength().intValue(), enter);
                CqlQuickfixProvider.this.emitQuickFixMetric(issue);
            }
        });
    }

    @Fix(value="TYPO_STATEMENT")
    public void fixTypo(Issue issue, IssueResolutionAcceptor acceptor) {
        int dist;
        Keyword candidate;
        int shortestDistance = 100;
        String shortestString = "";
        int foundAt = 0;
        String typo = issue.getData()[0].toUpperCase();
        Keyword[] keywordArray = Keyword.values();
        int n = keywordArray.length;
        int n2 = 0;
        while (n2 < n) {
            candidate = keywordArray[n2];
            if (candidate.isStartingKeyword() && (dist = LevenshteinDistance.computeLevenshteinDistance((CharSequence)typo, (CharSequence)candidate.toString())) < shortestDistance) {
                shortestDistance = dist;
                shortestString = candidate.toString();
                foundAt = 1;
            }
            ++n2;
        }
        if (issue.getData().length > 1) {
            typo = (String.valueOf(issue.getData()[0]) + issue.getData()[1]).toUpperCase();
            keywordArray = Keyword.values();
            n = keywordArray.length;
            n2 = 0;
            while (n2 < n) {
                candidate = keywordArray[n2];
                if (candidate.isStartingKeyword() && (dist = LevenshteinDistance.computeLevenshteinDistance((CharSequence)typo, (CharSequence)candidate.toString())) < shortestDistance) {
                    shortestDistance = dist;
                    shortestString = candidate.toString();
                    foundAt = 2;
                }
                ++n2;
            }
        }
        if (foundAt != 0 && shortestDistance < 3) {
            final int numberOfTokensToModify = foundAt;
            final String correction = shortestString;
            acceptor.accept(issue, "change to " + shortestString, "change to " + shortestString, null, new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    EList typos = ((TypoStatement)element).getTypos();
                    typos.set(0, (Object)correction);
                    if (numberOfTokensToModify == 2) {
                        typos.set(1, (Object)"");
                    }
                }
            });
        }
    }

    @Fix(value="FUNCTION_NAME_NOT_EXIST")
    public void findAlterFunctionName(Issue issue, IssueResolutionAcceptor acceptor) {
        this.proposeSimilarExistingElements(issue, acceptor, BuiltInFunctionsRegistry.getBuiltInFunctions());
    }

    @Fix(value="UNKNOWN_CQL3_FUNCTION_CALLED")
    public void fixDropFunctionUnknownFunction(Issue issue, IssueResolutionAcceptor acceptor) {
        this.proposeIfExistForDropFunction(issue, acceptor);
    }

    @Fix(value="FUNCTION_ARG_TYPES_DO_NOT_MATCH_ANY_FUNCTION")
    public void fixDropFunctionArgsDontMatchAnyFunction(Issue issue, IssueResolutionAcceptor acceptor) {
        this.proposeIfExistForDropFunction(issue, acceptor);
    }

    @Fix(value="FUNCTION_ARG_TYPES_DO_NOT_MATCH_FUNCTION")
    public void fixDropFunctionArgsDontMatchFunction(Issue issue, IssueResolutionAcceptor acceptor) {
        this.proposeIfExistForDropFunction(issue, acceptor);
    }

    private void proposeIfExistForDropFunction(Issue issue, IssueResolutionAcceptor acceptor) {
        CqlContext cqlContext = this.getCqlContext(issue);
        StatementIndexMap statementIndexMap = cqlContext.getStatementIndexMap();
        CqlStatement stmt = statementIndexMap.getStatementAtOffset(issue.getOffset().intValue());
        if (stmt != null && stmt instanceof DropFunctionStatement) {
            if (((DropFunctionStatement)stmt).isIfExists()) {
                return;
            }
            acceptor.accept(issue, "Add IF EXISTS to this statement", "", null, new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    CqlStatement stmt = ModelUtil.getCqlStatement((EObject)element);
                    if (stmt instanceof DropFunctionStatement) {
                        DropFunctionStatement dropFunctionStmt = (DropFunctionStatement)stmt;
                        dropFunctionStmt.setIfExists(true);
                    }
                }
            });
        }
    }

    @Fix(value="A_COLUMN_OF_A_PARTITION_KEY_CAN_BE_RESTRICTED_ONLY_IF_THE_PRECEDING_ONE_IS_RESTRICTED_BY_AN_EQUAL_RELATION")
    public void fixRestrictPartitionKeyBeforeThis(final Issue issue, IssueResolutionAcceptor acceptor) {
        final String nameToAdd = issue.getData()[0];
        final String typeToAdd = issue.getData()[1];
        acceptor.accept(issue, "add " + nameToAdd + " = value", "add " + nameToAdd + " = value", null, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                IXtextDocument doc = context.getXtextDocument();
                doc.replace(issue.getOffset().intValue(), 0, String.format("%s = %sValue AND ", ModelUtil.escapeName((String)nameToAdd), typeToAdd));
                CqlQuickfixProvider.this.emitQuickFixMetric(issue);
            }
        });
    }

    @Fix(value="NON_FROZEN_TUPLES_ARE_NOT_SUPPORTED")
    public void freezeTupleTypes(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add FROZEN<> keyword", "Tuple types must be frozen", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                String str = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), "FROZEN<" + str + '>');
                CqlQuickfixProvider.this.emitQuickFixMetric(issue);
            }
        });
    }

    @Fix(value="NON_FROZEN_USER_DEFINED_TYPES_ARE_NOT_SUPPORTED")
    public void freezeUserDefinedTypes(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add FROZEN<> keyword", "User-defined types must be frozen", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                String str = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), "FROZEN<" + str + '>');
                CqlQuickfixProvider.this.emitQuickFixMetric(issue);
            }
        });
    }

    @Fix(value="NON_FROZEN_COLLECTIONS_ARE_NOT_ALLOWED_INSIDE_COLLECTIONS")
    public void freezeCollectionTypes(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add FROZEN<> keyword", "Nested collections must be frozen", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                String str = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), "FROZEN<" + str + '>');
                CqlQuickfixProvider.this.emitQuickFixMetric(issue);
            }
        });
    }

    @Fix(value="FROZEN_KEYWORD_UNNECESSARILY_NESTED")
    public void unfreezeNestedFrozenKeywords(Issue issue, IssueResolutionAcceptor acceptor) {
        this.proposeUnfreeze(issue, acceptor);
    }

    @Fix(value="FROZEN_IS_CURRENTLY_ONLY_ALLOWED_ON_USER_DEFINED_AND_TUPLE_TYPES")
    public void unfreezeTypesBeforeFrozenCollections(Issue issue, IssueResolutionAcceptor acceptor) {
        this.proposeUnfreeze(issue, acceptor);
    }

    @Fix(value="FROZEN_IS_ONLY_ALLOWED_ON_COLLECTIONS_TUPLES_AND_USER_DEFINED_TYPES")
    public void unfreezeTypes(Issue issue, IssueResolutionAcceptor acceptor) {
        this.proposeUnfreeze(issue, acceptor);
    }

    @Fix(value="FROZEN_IS_NOT_ALLOWED_ON_FUNCTION_ARGUMENTS")
    public void unfreezeTypesInFunctionArguments(Issue issue, IssueResolutionAcceptor acceptor) {
        this.proposeUnfreeze(issue, acceptor);
    }

    private void proposeUnfreeze(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove FROZEN<> keyword", "Remove frozen<> keyword", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                String str = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                int start = StringUtils.indexOfIgnoreCase((String)str, (String)"FROZEN");
                start = str.indexOf(60, start);
                int end = str.lastIndexOf(62);
                if (start >= 0 && end >= 0) {
                    xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), str.substring(start + 1, end));
                    CqlQuickfixProvider.this.emitQuickFixMetric(issue);
                }
            }
        });
    }

    @Fix(value="DUPLICATE_PROPERTY_NAME")
    public void fixDuplicatePropertyName(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove duplicate property", "Remove duplicate property", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                StatementsWithProperties stmt = (StatementsWithProperties)element;
                int idx = Integer.parseInt(issue.getData()[0]);
                stmt.getProperties().remove(idx);
            }
        });
    }

    @Fix(value="INVALID_PROPERTY_NAME")
    public void fixInvalidPropertyName(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove property", "Remove property", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                Property property = (Property)element;
                StatementsWithProperties stmt = (StatementsWithProperties)property.eContainer();
                stmt.getProperties().remove((Object)property);
            }
        });
    }

    @Fix(value="CUSTOM_INDEX_REQUIRES_SPECIFIYING_THE_INDEX_CLASS")
    public void fixCustomIndexNeedClass(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove CUSTOM keyword", "Remove CUSTOM keyword", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                CreateIndexStatement stmt = (CreateIndexStatement)element;
                stmt.setCustom(false);
            }
        });
        acceptor.accept(issue, "Add USING clause", "Add USING clause", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                CreateIndexStatement stmt = (CreateIndexStatement)element;
                stmt.setIndexClass("'className'");
            }
        });
    }

    @Fix(value="CANNOT_SPECIFY_INDEX_CLASS_FOR_A_NON_CUSTOM_INDEX")
    public void fixNonCustomIndexClass(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add CUSTOM keyword", "Add CUSTOM keyword", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                CreateIndexStatement stmt = (CreateIndexStatement)element;
                stmt.setCustom(true);
            }
        });
        acceptor.accept(issue, "Remove USING clause", "Remove USING clause", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                CreateIndexStatement stmt = (CreateIndexStatement)element;
                stmt.setIndexClass(null);
            }
        });
    }

    @Fix(value="CANNOT_SPECIFY_OPTIONS_FOR_A_NON_CUSTOM_INDEX")
    public void fixNonCustomIndexOptions(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add CUSTOM keyword", "Add CUSTOM keyword", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                CreateIndexStatement stmt = (CreateIndexStatement)element;
                stmt.setCustom(true);
            }
        });
        acceptor.accept(issue, "Remove WITH clause", "Remove WITH clause", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                CreateIndexStatement stmt = (CreateIndexStatement)element;
                stmt.getProperties().clear();
            }
        });
    }

    @Fix(value="SIMPLIFY_REPLICATION_CLASS")
    public void simplifyReplicationClass(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Simplify", "Remove package prefix", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                IXtextDocument doc = context.getXtextDocument();
                MapEntry mapEntry = (MapEntry)element;
                ReplicationStrategy replicationStrategy = ReplicationStrategy.lookup((String)ModelUtil.stripName((String)ModelUtil.termToString((Term)mapEntry.getValue())));
                doc.replace(issue.getOffset().intValue(), issue.getLength().intValue(), ModelUtil.quote((String)replicationStrategy.getSimpleName()));
                CqlQuickfixProvider.this.emitQuickFixMetric(issue);
            }
        });
    }

    @Fix(value="LEGACY_OLD_NETWORK_TOPOLOGY_STRATEGY")
    public void quickFixOldNetworkTopologyStrategy(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Change to 'NetworkTopologyStrategy'", "Convert 'OldNetworkTopologyStrategy' to 'NetworkTopologyStrategy'", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                IXtextDocument doc = context.getXtextDocument();
                doc.replace(issue.getOffset().intValue(), issue.getLength().intValue(), ModelUtil.quote((String)ReplicationStrategy.NETWORK_TOPOLOGY.getSimpleName()));
                CqlQuickfixProvider.this.emitQuickFixMetric(issue);
            }
        });
    }

    private void emitQuickFixMetric(Issue issue) {
        if (issue != null && issue.getCode() != null) {
            Metrics.incrementCounter((String)(String.valueOf(issue.getCode()) + "_quick_fix_count"));
        }
    }
}

