/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.selection.listeners;

import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import java.util.HashMap;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class CqlResultsCellSelectionListener
implements ISelectionChangedListener {
    private EventAdmin eventAdmin;

    public CqlResultsCellSelectionListener() {
        BundleContext ctx = FrameworkUtil.getBundle(CqlEditorPart.class).getBundleContext();
        ServiceReference ref = ctx.getServiceReference(EventAdmin.class);
        this.eventAdmin = (EventAdmin)ctx.getService(ref);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        int columnIndex;
        TableViewer tableViewer = (TableViewer)event.getSource();
        ViewerCell viewerCell = tableViewer.getColumnViewerEditor().getFocusCell();
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (viewerCell == null) {
            activePage.hideView(activePage.findView("com.datastax.devcenter.cql.ui.views.DetailedResultsViewPart"));
            this.fireEvent(null);
            return;
        }
        Object[] rowElements = (Object[])viewerCell.getElement();
        if (rowElements.length > (columnIndex = viewerCell.getColumnIndex())) {
            try {
                activePage.showView("com.datastax.devcenter.cql.ui.views.DetailedResultsViewPart");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            this.fireEvent(rowElements[columnIndex]);
        }
    }

    public void fireEvent(Object selectedCell) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cell", selectedCell);
        Event event = new Event("resultViewer/cellSelection", properties);
        this.eventAdmin.sendEvent(event);
    }
}

