/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.selection.listeners;

import com.datastax.devcenter.common.utils.ExportTableUtils;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class SelectableCellTableViewer {
    private TableViewer innerTableViewer;
    private Object selectedCell;

    public SelectableCellTableViewer(Composite parent, int style) {
        this.innerTableViewer = new TableViewer(parent, style);
        this.enabledSingleCellSelection();
    }

    private void enabledSingleCellSelection() {
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.innerTableViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.innerTableViewer));
        TableViewerEditor.create((TableViewer)this.innerTableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.innerTableViewer), (int)26);
        CellSelectionListener cellSelectionListener = new CellSelectionListener();
        this.innerTableViewer.addSelectionChangedListener((ISelectionChangedListener)cellSelectionListener);
    }

    public Object getSelectedCell() {
        return this.selectedCell;
    }

    public Object getRawValue() {
        if (this.selectedCell instanceof ExportTableUtils.ICellWrapper) {
            return ((ExportTableUtils.ICellWrapper)this.selectedCell).getCell();
        }
        return this.selectedCell;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.innerTableViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.innerTableViewer.removeSelectionChangedListener(listener);
    }

    public Table getTable() {
        return this.innerTableViewer.getTable();
    }

    public void setContentProvider(IContentProvider provider) {
        this.innerTableViewer.setContentProvider(provider);
    }

    public final void setInput(Object input) {
        this.innerTableViewer.setInput(input);
    }

    public void refresh() {
        this.innerTableViewer.refresh();
    }

    public TableViewer getInnerTableViewer() {
        return this.innerTableViewer;
    }

    private class CellSelectionListener
    implements ISelectionChangedListener {
        private CellSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            int columnIndex;
            TableViewer tableViewer = (TableViewer)event.getSource();
            ViewerCell viewerCell = tableViewer.getColumnViewerEditor().getFocusCell();
            if (viewerCell == null) {
                SelectableCellTableViewer.this.selectedCell = null;
                return;
            }
            Object[] rowElements = (Object[])viewerCell.getElement();
            if (rowElements.length > (columnIndex = viewerCell.getColumnIndex())) {
                SelectableCellTableViewer.this.selectedCell = rowElements[columnIndex];
            }
        }
    }
}

