/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.sorters;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public abstract class ColumnViewerSorter
extends ViewerComparator {
    public static final int ASC = 1;
    public static final int NONE = 0;
    public static final int DESC = -1;
    public static final int NULL_ELEMENT_COMPARISON = 1;
    private int direction = 0;
    private final ColumnViewer columnViewer;
    private final TableViewerColumn tableViewerColumn;
    protected int columnIndex;

    public ColumnViewerSorter(ColumnViewer columnViewer, TableViewerColumn tableViewerColumn, int columnIndex) {
        this.columnViewer = columnViewer;
        this.tableViewerColumn = tableViewerColumn;
        this.columnIndex = columnIndex;
        this.tableViewerColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ColumnViewerSorter.this.columnViewer.getComparator() != null) {
                    if (ColumnViewerSorter.this.columnViewer.getComparator() == ColumnViewerSorter.this) {
                        int sortDirection = ColumnViewerSorter.this.direction;
                        if (sortDirection == 1) {
                            ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, -1);
                        } else if (sortDirection == -1) {
                            ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 0);
                        }
                    } else {
                        ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 1);
                    }
                } else {
                    ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 1);
                }
            }
        });
    }

    public void setSorter(ColumnViewerSorter sorter, int direction) {
        if (direction == 0) {
            this.tableViewerColumn.getColumn().getParent().setSortColumn(null);
            this.tableViewerColumn.getColumn().getParent().setSortDirection(0);
            this.columnViewer.setComparator(null);
        } else {
            this.tableViewerColumn.getColumn().getParent().setSortColumn(this.tableViewerColumn.getColumn());
            sorter.direction = direction;
            if (direction == 1) {
                this.tableViewerColumn.getColumn().getParent().setSortDirection(128);
            } else {
                this.tableViewerColumn.getColumn().getParent().setSortDirection(1024);
            }
            if (this.columnViewer.getComparator() == sorter) {
                this.columnViewer.refresh();
            } else {
                this.columnViewer.setComparator((ViewerComparator)sorter);
            }
            this.columnViewer.refresh();
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.direction * this.doCompare(viewer, e1, e2);
    }

    protected abstract int doCompare(Viewer var1, Object var2, Object var3);
}

