/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.utils;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.models.ConnectionList;
import com.datastax.devcenter.connections.ui.views.providers.ConnectionProvider;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.KeyspaceProvider;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;

public class StructuredSelectionUtils {
    public static Connection getActiveConnection(IWorkbench workbench, IStructuredSelection selection) {
        Connection connection = null;
        IWorkbenchPart part = workbench.getActiveWorkbenchWindow().getPartService().getActivePart();
        if (part instanceof ConnectionProvider) {
            connection = ((ConnectionProvider)part).getConnection();
        }
        if (connection == null && selection != null) {
            Object element = selection.getFirstElement();
            if (element instanceof Connection) {
                connection = (Connection)element;
            }
            if (connection == null && element instanceof ConnectionProvider) {
                connection = ((ConnectionProvider)element).getConnection();
            }
        }
        if (connection == null) {
            List connections = ConnectionList.getInstance().getConnections();
            for (Connection conn : connections) {
                if (!conn.isOpen()) continue;
                connection = conn;
                break;
            }
            if (connection == null && !connections.isEmpty()) {
                connection = (Connection)connections.get(0);
            }
        }
        return connection;
    }

    public static Keyspace getActiveKeyspace(IWorkbench workbench, IStructuredSelection selection) {
        Keyspace temp;
        Keyspace keyspace = null;
        IWorkbenchPart part = workbench.getActiveWorkbenchWindow().getPartService().getActivePart();
        if (part instanceof KeyspaceProvider && (temp = ((KeyspaceProvider)part).getKeyspace()) != null && !temp.isSystemKeyspace()) {
            keyspace = temp;
        }
        if (keyspace == null && selection != null) {
            Keyspace temp2;
            Object element = selection.getFirstElement();
            if (element instanceof Keyspace && !((Keyspace)element).isSystemKeyspace()) {
                keyspace = (Keyspace)element;
            }
            if (keyspace == null && element instanceof KeyspaceProvider && (temp2 = ((KeyspaceProvider)element).getKeyspace()) != null && !temp2.isSystemKeyspace()) {
                keyspace = temp2;
            }
        }
        return keyspace;
    }
}

