/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.views;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.cql.ui.CqlActivator;
import com.datastax.devcenter.cql.ui.providers.CqlScriptsTreeContentProvider;
import com.datastax.devcenter.cql.ui.providers.CqlScriptsViewLabelProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class CqlScriptsViewPart
extends ViewPart {
    public static final String ID = "com.datastax.devcenter.cql.ui.views.CqlScriptsViewPart";
    private static final String CQL_CONTEXT_ID = "com.datastax.devcenter.cql.ui.views";
    private static final String OPEN_CQL_SCRIPT_COMMAND_ID = "com.datastax.devcenter.cql.ui.commands.OpenCqlScript";
    private TreeViewer treeViewer;

    public void createPartControl(Composite parentComposite) {
        this.activateCqlContext();
        this.createTreeViewer(parentComposite);
        this.hookContextMenu();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    private void activateCqlContext() {
        IContextService service = (IContextService)this.getSite().getService(IContextService.class);
        service.activateContext(CQL_CONTEXT_ID);
    }

    private void createTreeViewer(Composite parentComposite) {
        this.treeViewer = new TreeViewer(parentComposite, 514);
        this.treeViewer.setContentProvider((IContentProvider)new CqlScriptsTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CqlScriptsViewLabelProvider());
        this.treeViewer.setInput((Object)CqlActivator.getCqlFilesScriptsManager().getScriptsIFolder());
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IHandlerService handlerService = (IHandlerService)CqlScriptsViewPart.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand(CqlScriptsViewPart.OPEN_CQL_SCRIPT_COMMAND_ID, null);
                }
                catch (Exception e) {
                    DevCenterLogger.error((Throwable)e, (String)e.toString(), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                }
                CqlScriptsViewPart.this.treeViewer.refresh();
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    public void notifyScriptsFolderChanged() {
        this.treeViewer.setInput((Object)CqlActivator.getCqlFilesScriptsManager().getScriptsIFolder());
    }

    public void notifyScriptListChanged() {
        this.treeViewer.setInput((Object)CqlActivator.getCqlFilesScriptsManager().getScriptsIFolder());
    }
}

