/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.views;

import com.datastax.devcenter.cql.ui.editor.embedded.EmbeddedJsonViewer;
import com.datastax.devcenter.cql.ui.providers.cell.CqlResultsCellWrapper;
import com.datastax.devcenter.json.ui.util.CqlResultsSerializer;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DetailedResultsViewPart
extends ViewPart {
    public static final String ID = "com.datastax.devcenter.cql.ui.views.DetailedResultsViewPart";
    private static final String DETAILED_RESULTS_CONTEXT_ID = "com.datastax.devcenter.cql.ui.views";
    private Composite composite;
    private Text typeText;
    private Text timestampText;
    private Text ttlText;
    private Text valueText;
    private Composite textComposite;
    private Composite jsonComposite;
    private ServiceRegistration<EventHandler> eventHandler;
    private static int NUMBER_TOP_LEVEL_FIELDS = 0;
    private EmbeddedJsonViewer jsonViewer;
    private StackLayout stackLayout;
    private Composite stackComposite;
    private EventHandler handler = new EventHandler(){

        public void handleEvent(Event event) {
            CqlResultsCellWrapper cellWrapper = (CqlResultsCellWrapper)event.getProperty("cell");
            DetailedResultsViewPart.this.composite.setVisible(true);
            DetailedResultsViewPart.this.setTextValue(cellWrapper);
            DetailedResultsViewPart.this.composite.layout();
            DetailedResultsViewPart.this.typeText.setText(cellWrapper.getType().toString());
            DetailedResultsViewPart.this.setTtlValue(cellWrapper.getTtl());
            DetailedResultsViewPart.this.setTimestampValue(cellWrapper.getTimestamp());
        }
    };

    public DetailedResultsViewPart() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", "resultViewer/cellSelection");
        BundleContext ctx = FrameworkUtil.getBundle(DetailedResultsViewPart.class).getBundleContext();
        this.eventHandler = ctx.registerService(EventHandler.class, (Object)this.handler, properties);
    }

    public void createPartControl(Composite parentComposite) {
        this.activateCqlContext();
        this.layoutComponents(parentComposite);
    }

    private void setTtlValue(Integer ttl) {
        if (ttl != null && ttl == Integer.MIN_VALUE) {
            this.ttlText.setText("[Not available]");
        } else {
            this.ttlText.setText(String.valueOf(ttl));
        }
    }

    private void setTimestampValue(Long timestamp) {
        if (timestamp != null && timestamp == Long.MIN_VALUE) {
            this.timestampText.setText("[Not available]");
        } else {
            this.timestampText.setText(String.valueOf(this.toDate(timestamp)));
        }
        if (timestamp != null && timestamp != Long.MIN_VALUE) {
            this.timestampText.setToolTipText(String.valueOf(timestamp));
        } else {
            this.timestampText.setToolTipText("");
        }
    }

    private void setTextValue(CqlResultsCellWrapper wrapper) {
        Object cell = wrapper.getCell();
        if (wrapper.isToJson() || CqlResultsSerializer.shouldRenderAsJson(cell)) {
            this.jsonViewer.setContent((List<String>)ImmutableList.of((Object)CqlResultsSerializer.serialize(cell)), NUMBER_TOP_LEVEL_FIELDS);
            this.stackLayout.topControl = this.jsonComposite;
        } else {
            this.valueText.setText(CqlResultsSerializer.serialize(cell));
            this.stackLayout.topControl = this.textComposite;
        }
        this.stackComposite.layout();
    }

    private void layoutComponents(Composite parentComposite) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        parentComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        parentComposite.setLayout((Layout)gridLayout);
        this.layoutTypeRow(parentComposite);
        this.layoutTimestampRow(parentComposite);
        this.layoutTtlRow(parentComposite);
        this.layoutValueRow(parentComposite);
        this.composite = parentComposite;
        this.composite.setVisible(false);
    }

    private void layoutTypeRow(Composite parentComposite) {
        Composite row = this.getRow(parentComposite);
        this.getLabel(row, "Type:");
        this.typeText = new Text(row, 0);
        this.typeText.setLayoutData((Object)new GridData(768));
        this.typeText.setEditable(false);
    }

    private void layoutTimestampRow(Composite parentComposite) {
        Composite row = this.getRow(parentComposite);
        this.getLabel(row, "Timestamp:");
        this.timestampText = new Text(row, 0);
        this.timestampText.setLayoutData((Object)new GridData(768));
        this.timestampText.setEditable(false);
    }

    private void layoutTtlRow(Composite parentComposite) {
        Composite row = this.getRow(parentComposite);
        this.getLabel(row, "TTL:");
        this.ttlText = new Text(row, 0);
        this.ttlText.setLayoutData((Object)new GridData(768));
        this.ttlText.setEditable(false);
    }

    private void layoutValueRow(Composite parentComposite) {
        GridData gridData = new GridData(1808);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.stackComposite = new Composite(parentComposite, 0);
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.stackComposite.setLayoutData((Object)gridData);
        this.layoutTextStringRow(this.stackComposite);
        this.layoutTextJson(this.stackComposite);
        this.stackLayout.topControl = this.textComposite;
    }

    private void layoutTextStringRow(Composite parentComposite) {
        GridData gridData = new GridData(1808);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.textComposite = new Composite(parentComposite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.textComposite.setLayout((Layout)gridLayout);
        this.textComposite.setLayoutData((Object)gridData);
        GridData valueLabelGrid = new GridData(1040);
        valueLabelGrid.verticalAlignment = 128;
        Label valueLabel = this.getLabel(this.textComposite, "Value:");
        valueLabel.setLayoutData((Object)valueLabelGrid);
        this.valueText = new Text(this.textComposite, 74);
        this.valueText.setLayoutData((Object)gridData);
    }

    private void layoutTextJson(Composite parentComposite) {
        this.jsonComposite = this.getRow(parentComposite, 1);
        GridData gridData = new GridData(1808);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.jsonComposite.setLayoutData((Object)gridData);
        Composite jsonLabelRow = this.getRow(this.jsonComposite, 1);
        this.getLabel(jsonLabelRow, "Value:");
        Composite textJsonRow = this.getRow(this.jsonComposite, 1);
        textJsonRow.setLayoutData((Object)gridData);
        this.jsonViewer = EmbeddedJsonViewer.buildJsonViewer((List<String>)ImmutableList.of((Object)"{}"), NUMBER_TOP_LEVEL_FIELDS, textJsonRow);
        this.jsonViewer.renderView();
        this.jsonViewer.expandAll();
    }

    private Composite getRow(Composite parentComposite, int columns) {
        Composite row = new Composite(parentComposite, 0);
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        row.setLayout((Layout)gridLayout);
        GridData rowGridData = new GridData(768);
        rowGridData.grabExcessHorizontalSpace = true;
        row.setLayoutData((Object)rowGridData);
        return row;
    }

    private Composite getRow(Composite parentComposite) {
        return this.getRow(parentComposite, 2);
    }

    private Label getLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setFont(JFaceResources.getFontRegistry().getBold(""));
        label.setText(text);
        return label;
    }

    public void setFocus() {
    }

    private void activateCqlContext() {
        IContextService service = (IContextService)this.getSite().getService(IContextService.class);
        service.activateContext(DETAILED_RESULTS_CONTEXT_ID);
    }

    public void dispose() {
        super.dispose();
        this.eventHandler.unregister();
    }

    private Date toDate(Long timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Date(timestamp / 1000L);
    }
}

