/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl;

import com.datastax.devcenter.common.metrics.Metrics;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.ui.CqlActivator;
import com.datastax.devcenter.cql.ui.editor.embedded.EmbeddedCqlEditor;
import com.datastax.devcenter.cql.ui.editor.embedded.EmbeddedCqlEditorResourceProvider;
import com.datastax.devcenter.cql.ui.editor.embedded.EmbeddedCqlEditorValidationStatusProvider;
import com.datastax.devcenter.cql.ui.utils.StructuredSelectionUtils;
import com.datastax.devcenter.cql.ui.wizards.ddl.AbstractWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.actions.CompoundDDLWizardAction;
import com.datastax.devcenter.cql.ui.wizards.ddl.actions.DDLWizardAction;
import com.datastax.devcenter.cql.ui.wizards.ddl.actions.InsertStatementsInExistingEditorDDLWizardAction;
import com.datastax.devcenter.cql.ui.wizards.ddl.actions.InsertStatementsInNewEditorDDLWizardAction;
import com.datastax.devcenter.cql.ui.wizards.ddl.actions.StatementExecutingDDLWizardAction;
import com.datastax.devcenter.cql.ui.wizards.ddl.actions.StatementSerializingDDLWizardAction;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.SummaryDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreviewContentProvider;
import com.datastax.devcenter.cql.util.TypeParser;
import com.datastax.devcenter.schema.ISchemaElement;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaInitializer;
import com.google.inject.Injector;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;

public abstract class DDLWizard<E extends ISchemaElement>
extends AbstractWizard
implements CqlPreviewContentProvider,
INewWizard {
    private final Class<E> schemaElementClass;
    private DDLWizardModel<E> model;
    private DDLWizardDescription description;
    private DDLStatementGenerator<E> generator;
    private CqlPreview cqlPreview;
    private ISerializer serializer;
    private EmbeddedCqlEditorResourceProvider resourceProvider;
    private TypeParser typeParser;
    private SchemaInitializer schemaInitializer;
    private SummaryDDLWizardPage<E> summaryPage;
    private DDLAction ddlAction;
    private boolean forceStatementExecution;

    public DDLWizard() {
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(true);
        this.schemaElementClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.ddlAction = DDLAction.CREATE;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.init(workbench, selection, DDLAction.CREATE, false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection, DDLAction ddlAction, boolean forceStatementExecution) {
        this.ddlAction = ddlAction;
        this.forceStatementExecution = forceStatementExecution;
        this.injectFields();
        this.model = this.createModel(workbench, selection);
        this.description = this.createDescription();
        this.setWindowTitle(this.description.getTitle());
        this.generator = this.createGenerator();
        Metrics.incrementCounter((String)this.metricName("started"));
    }

    protected void injectFields() {
        Injector injector = CqlActivator.getDefault().getInjector("com.datastax.devcenter.cql.Cql");
        this.serializer = (ISerializer)injector.getInstance(ISerializer.class);
        this.resourceProvider = (EmbeddedCqlEditorResourceProvider)injector.getInstance(EmbeddedCqlEditorResourceProvider.class);
        this.schemaInitializer = (SchemaInitializer)injector.getInstance(SchemaInitializer.class);
        this.typeParser = (TypeParser)injector.getInstance(TypeParser.class);
        EmbeddedCqlEditor editor = (EmbeddedCqlEditor)injector.getInstance(EmbeddedCqlEditor.class);
        this.cqlPreview = new CqlPreview(editor, this);
    }

    protected E getSelectedSchemaElement(IWorkbench workbench, IStructuredSelection selection) {
        Object element;
        if (selection != null && !selection.isEmpty() && this.schemaElementClass.isAssignableFrom((element = selection.getFirstElement()).getClass())) {
            return (E)((ISchemaElement)element);
        }
        return null;
    }

    protected Keyspace getActiveKeyspace(IWorkbench workbench, IStructuredSelection selection) {
        Schema schema;
        Keyspace keyspace = StructuredSelectionUtils.getActiveKeyspace(workbench, selection);
        if (keyspace == null && (schema = this.getActiveSchema(workbench, selection)) != null) {
            List keyspaces = schema.getKeyspaces();
            for (Keyspace ks : keyspaces) {
                if (ks.isSystemKeyspace()) continue;
                keyspace = ks;
                break;
            }
        }
        return keyspace;
    }

    protected Schema getActiveSchema(IWorkbench workbench, IStructuredSelection selection) {
        Connection connection = StructuredSelectionUtils.getActiveConnection(workbench, selection);
        return this.schemaInitializer.init(connection);
    }

    public DDLWizardModel<E> getModel() {
        return this.model;
    }

    public DDLAction getDDLAction() {
        return this.ddlAction;
    }

    public boolean isCreation() {
        return this.ddlAction == DDLAction.CREATE || this.ddlAction == DDLAction.CLONE;
    }

    public final void addPages() {
        List<DDLWizardPage<E>> mainPages = this.createWizardSpecificPages(this.model, this.cqlPreview, this.typeParser);
        for (DDLWizardPage<E> page : mainPages) {
            this.addPage((IWizardPage)page);
        }
        DDLWizardDescription summaryDescription = new DDLWizardDescription("Summary", null);
        this.summaryPage = new SummaryDDLWizardPage<E>(this.model, summaryDescription, this.cqlPreview, this.ddlAction, this.getSummaryHelpUrl(), this.forceStatementExecution);
        this.addPage((IWizardPage)this.summaryPage);
    }

    protected String getSummaryHelpUrl() {
        return ((DDLWizardPage)this.getPages()[0]).getHelpUrl();
    }

    @Override
    public String getPreviewText() {
        try {
            String prefix = this.getPreviewTextPrefix(this.model);
            String suffix = this.getPreviewTextSuffix(this.model);
            Statements statements = this.generator.generate(this.model);
            String contents = this.serialize(statements);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (prefix != null && !prefix.isEmpty()) {
                pw.println(prefix);
            }
            pw.println(contents);
            if (suffix != null && !suffix.isEmpty()) {
                pw.println(suffix);
            }
            return sw.toString();
        }
        catch (Exception exception) {
            String text = "// Invalid CQL syntax";
            return text;
        }
    }

    public void createCqlPreviewPart(Composite container) {
        this.cqlPreview.createControl(container);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        EmbeddedCqlEditorValidationStatusProvider validationStatusProvider = this.cqlPreview.createValidationStatusProvider();
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            ((DDLWizardPage)page).setCqlPreviewValidationStatusProvider((ValidationStatusProvider)validationStatusProvider);
            ++n2;
        }
        this.cqlPreview.addModelListener(new IXtextModelListener(){

            public void modelChanged(XtextResource resource) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DDLWizard.this.getContainer().updateButtons();
                    }
                });
            }
        });
    }

    public boolean canFinish() {
        return super.canFinish() && !this.cqlPreview.isEmpty();
    }

    public boolean performFinish() {
        Metrics.incrementCounter((String)this.metricName("finished"), (int)1);
        DDLWizardAction<E> action = this.createAction();
        if (action == null) {
            return true;
        }
        IStatus status = this.performAction(action);
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)this.description.getTitle(), (String)action.getErrorMessage(), (IStatus)status);
            this.cqlPreview.connectionChanged(this.model.getConnection());
            this.resyncModel(this.model, this.cqlPreview.getCqlContext().getDatabaseSchema());
            this.cqlPreview.updatePreview();
        }
        return status.isOK();
    }

    private String metricName(String context) {
        StringBuilder builder = this.baseMetricName();
        builder.append("_");
        builder.append(context);
        return builder.toString();
    }

    private StringBuilder baseMetricName() {
        StringBuilder builder = new StringBuilder();
        String wizardType = this.getClass().getSimpleName().replace("Wizard", "");
        builder.append(this.getDDLAction().toString().toLowerCase());
        builder.append("_");
        builder.append(wizardType);
        return builder;
    }

    public void dispose() {
        super.dispose();
        this.cqlPreview.dispose();
    }

    protected DDLWizardAction<E> createAction() {
        ArrayList<DDLWizardAction<StatementSerializingDDLWizardAction>> actions = new ArrayList<DDLWizardAction<StatementSerializingDDLWizardAction>>();
        if (this.summaryPage.shouldExecuteStatements()) {
            actions.add(new StatementExecutingDDLWizardAction<E>(this.model, this.generator));
        }
        if (this.summaryPage.shouldInsertStatementsIntoNewEditor()) {
            actions.add(new InsertStatementsInNewEditorDDLWizardAction<E>(this.model, this.generator, this.getPreviewTextPrefix(this.model), this.getPreviewTextSuffix(this.model)));
        }
        if (this.summaryPage.shouldInsertStatementsIntoExistingEditor()) {
            actions.add(new InsertStatementsInExistingEditorDDLWizardAction<E>(this.model, this.generator, this.getPreviewTextPrefix(this.model), this.getPreviewTextSuffix(this.model), this.summaryPage.getExistingEditorReference()));
        }
        if (actions.isEmpty()) {
            return null;
        }
        if (actions.size() == 1) {
            return (DDLWizardAction)actions.get(0);
        }
        return new CompoundDDLWizardAction<E>(this.model, this.generator, actions);
    }

    protected IStatus performAction(DDLWizardAction<E> action) {
        try {
            this.getContainer().run(true, true, action);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return action.getStatus();
    }

    protected String serialize(Statements statements) throws Exception {
        if (statements.getStatements().isEmpty()) {
            return "";
        }
        XtextResource temp = this.resourceProvider.createResource();
        temp.getContents().add((Object)statements);
        return this.serializer.serialize((EObject)statements);
    }

    protected String getPreviewTextPrefix(DDLWizardModel<E> model) {
        return "";
    }

    protected String getPreviewTextSuffix(DDLWizardModel<E> model) {
        return "";
    }

    protected abstract DDLWizardModel<E> createModel(IWorkbench var1, IStructuredSelection var2);

    protected abstract void resyncModel(DDLWizardModel<E> var1, Schema var2);

    protected abstract List<DDLWizardPage<E>> createWizardSpecificPages(DDLWizardModel<E> var1, CqlPreview var2, TypeParser var3);

    protected abstract DDLWizardDescription createDescription();

    protected abstract DDLStatementGenerator<E> createGenerator();

    public static enum DDLAction {
        CREATE,
        EDIT,
        CLONE;

    }
}

