/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl;

import com.datastax.devcenter.cql.ui.wizards.ddl.AbstractWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.SummaryDDLWizardPage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class DDLWizardDialog
extends WizardDialog {
    public DDLWizardDialog(Shell parentShell, DDLWizard<?> newWizard) {
        super(parentShell, newWizard);
    }

    protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout pmlayout) {
        this.createCqlPreviewPart(composite);
        return super.createProgressMonitorPart(composite, pmlayout);
    }

    private void createCqlPreviewPart(Composite composite) {
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DDLWizard wizard = (DDLWizard)this.getWizard();
        wizard.createCqlPreviewPart(composite);
    }

    public void updateButtons() {
        super.updateButtons();
        Button finishButton = this.getButton(16);
        if (this.getCurrentPage().getNextPage() == null) {
            finishButton.setText(IDialogConstants.FINISH_LABEL);
        } else {
            finishButton.setText("Last >>");
            if (this.getCurrentPage().getNextPage() instanceof SummaryDDLWizardPage) {
                this.enabled(15, this.canFinish());
            }
        }
        if (this.getCurrentPage().getPreviousPage() == null) {
            this.enabled(14, false);
        } else {
            this.enabled(14, this.canFinish());
        }
    }

    private void enabled(Button button, boolean enabled) {
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    private void enabled(int buttonId, boolean enabled) {
        this.enabled(this.getButton(buttonId), enabled);
    }

    private boolean canFinish() {
        IWizard wizard = this.getWizard();
        return ((AbstractWizard)wizard).canFinishWithoutInteraction();
    }

    protected void finishPressed() {
        if (this.getCurrentPage().getNextPage() == null) {
            super.finishPressed();
        } else {
            IWizardPage page = this.getCurrentPage();
            IWizardPage previous = this.getCurrentPage().getPreviousPage();
            while (page.getNextPage() != null) {
                previous = page;
                page = page.getNextPage();
            }
            this.showPage(page);
            page.setPreviousPage(previous);
        }
    }
}

