/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.ui.views.providers.ConnectionProvider;
import com.datastax.devcenter.cql.generators.DDLStatementGenerationContext;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.ISchemaElement;
import com.datastax.driver.core.VersionNumber;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class DDLWizardModel<E extends ISchemaElement>
implements DDLStatementGenerationContext<E>,
ConnectionProvider {
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private Connection connection;
    private E initial;
    private E current;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection newConnection) {
        VersionNumber oldVersion = this.getVersionNumber();
        Connection oldConnection = this.getConnection();
        this.connection = newConnection;
        VersionNumber newVersion = this.getVersionNumber();
        this.firePropertyChange("versionNumber", oldVersion, newVersion);
        this.firePropertyChange("connection", oldConnection, newConnection);
    }

    public E getCurrent() {
        return this.current;
    }

    public void setCurrent(E current) {
        this.current = current;
        this.firePropertyChange("current", this.current, this.current);
    }

    public E getInitial() {
        return this.initial;
    }

    public void setInitial(E initial) {
        this.initial = initial;
        this.firePropertyChange("initial", this.initial, this.initial);
    }

    public VersionNumber getVersionNumber() {
        if (this.connection == null) {
            return CqlConstants.defaultCassandraVersion();
        }
        VersionNumber version = this.connection.getCassandraVersion();
        if (version == null) {
            version = CqlConstants.defaultCassandraVersion();
        }
        return version;
    }
}

