/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl;

import com.datastax.devcenter.cql.generators.CreateIndexStatementGenerator;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.ui.utils.StructuredSelectionUtils;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.index.IndexBasicSettingsDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.cql.util.TypeParser;
import com.datastax.devcenter.schema.ITableElement;
import com.datastax.devcenter.schema.Indices;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.Table;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class IndexWizard
extends DDLWizard<Indices> {
    private String INDEX_HELP_URL = "http://docs.datastax.com/en/cql/3.1/cql/cql_reference/create_index_r.html";

    @Override
    protected DDLWizardModel<Indices> createModel(IWorkbench workbench, IStructuredSelection selection) {
        DDLWizardModel<Indices> model = new DDLWizardModel<Indices>();
        model.setConnection(StructuredSelectionUtils.getActiveConnection(workbench, selection));
        Schema parent = this.getActiveSchema(workbench, selection);
        Indices initial = parent.getIndices();
        model.setInitial(initial);
        Indices current = initial.deepCopy((Object)parent);
        current.setKeyspace(this.getActiveKeyspace(workbench, selection));
        current.setTable(this.getSelectedTable(selection));
        model.setCurrent(current);
        return model;
    }

    @Override
    protected DDLWizardDescription createDescription() {
        DDLWizardDescription description = new DDLWizardDescription();
        description.setTitle("Create index");
        description.setDescription("Create new indices");
        description.setImagePath("icons/index.gif");
        return description;
    }

    @Override
    protected DDLStatementGenerator<Indices> createGenerator() {
        return new CreateIndexStatementGenerator();
    }

    @Override
    protected List<DDLWizardPage<Indices>> createWizardSpecificPages(DDLWizardModel<Indices> model, CqlPreview cqlPreview, TypeParser typeParser) {
        ArrayList<DDLWizardPage<Indices>> pages = new ArrayList<DDLWizardPage<Indices>>();
        DDLWizardDescription description = new DDLWizardDescription("Create index", "Define new indices. Click Next to review summary.");
        pages.add(new IndexBasicSettingsDDLWizardPage(model, description, cqlPreview, this.getDDLAction(), this.INDEX_HELP_URL));
        return pages;
    }

    @Override
    protected void resyncModel(DDLWizardModel<Indices> model, Schema schema) {
        model.setInitial(schema.getIndices());
    }

    public Table getSelectedTable(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            Object selectedObject = selection.getFirstElement();
            if (ITableElement.class.isInstance(selectedObject)) {
                return ((ITableElement)selectedObject).getTable();
            }
            if (Table.class.isInstance(selectedObject)) {
                return (Table)selectedObject;
            }
        }
        return null;
    }

    @Override
    protected boolean canFinishWithoutInteraction() {
        return this.canFinish();
    }
}

