/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl;

import com.datastax.devcenter.cql.generators.AlterKeyspaceStatementGenerator;
import com.datastax.devcenter.cql.generators.CreateKeyspaceStatementGenerator;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.ui.utils.StructuredSelectionUtils;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.keyspace.KeyspaceBasicSettingsDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.cql.util.TypeParser;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.options.KeyspaceOptions;
import com.datastax.devcenter.schema.options.KeyspaceReplication;
import com.datastax.devcenter.schema.options.OptionsHelper;
import com.datastax.driver.core.VersionNumber;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class KeyspaceWizard
extends DDLWizard<Keyspace> {
    private static final String CREATE_KEYSPACE_HELP_URL = "http://www.datastax.com/documentation/cql/3.1/cql/cql_reference/create_keyspace_r.html";
    private static final String ALTER_KEYSPACE_HELP_URL = "http://www.datastax.com/documentation/cql/3.1/cql/cql_reference/alter_keyspace_r.html";

    @Override
    protected DDLWizardModel<Keyspace> createModel(IWorkbench workbench, IStructuredSelection selection) {
        Keyspace initial;
        DDLWizardModel<Keyspace> model = new DDLWizardModel<Keyspace>();
        Keyspace selected = (Keyspace)this.getSelectedSchemaElement(workbench, selection);
        switch (this.getDDLAction()) {
            default: {
                Schema parent = this.getActiveSchema(workbench, selection);
                initial = new Keyspace(Schema.availableKeyspaceName((Schema)parent, (String)"keyspace"));
                initial.setSchema(parent);
                KeyspaceReplication keyspaceReplication = initial.getOptions().getReplication();
                if (!keyspaceReplication.getNetworkStrategyDataCenters().isEmpty()) break;
                keyspaceReplication.addDataCenter(new KeyspaceReplication.DataCenter("datacenter1", Integer.valueOf(1)));
                break;
            }
            case CLONE: {
                initial = selected.deepCopy((Object)selected.getSchema());
                initial.setName(Schema.availableKeyspaceName((Schema)selected.getSchema(), (String)(String.valueOf(selected.getName()) + "_copy")));
                break;
            }
            case EDIT: {
                Assert.isNotNull((Object)selected);
                initial = selected;
                VersionNumber versionNumber = model.getVersionNumber();
                KeyspaceOptions options = selected.getOptions();
                OptionsHelper.setDefaultValueForNullOptions((Object)options, (VersionNumber)versionNumber);
                OptionsHelper.setDefaultValueForNullOptions((Object)options.getReplication(), (VersionNumber)versionNumber);
            }
        }
        model.setConnection(StructuredSelectionUtils.getActiveConnection(workbench, selection));
        model.setInitial(initial);
        model.setCurrent(initial.deepCopy((Object)initial.getSchema()));
        return model;
    }

    @Override
    protected void resyncModel(DDLWizardModel<Keyspace> model, Schema schema) {
        if (!this.isCreation()) {
            Keyspace oldInitial = model.getInitial();
            Keyspace newInitial = schema.getKeyspace(oldInitial.getName());
            model.setInitial(newInitial);
        }
    }

    @Override
    protected DDLWizardDescription createDescription() {
        DDLWizardDescription description = new DDLWizardDescription();
        if (this.isCreation()) {
            description.setTitle("New Keyspace");
            description.setDescription("Create a new CQL keyspace");
        } else {
            description.setTitle("Edit Keyspace");
            description.setDescription("Edit the selected CQL keyspace");
        }
        description.setImagePath("icons/keyspace.gif");
        return description;
    }

    @Override
    protected DDLStatementGenerator<Keyspace> createGenerator() {
        if (this.isCreation()) {
            return new CreateKeyspaceStatementGenerator();
        }
        return new AlterKeyspaceStatementGenerator();
    }

    @Override
    protected List<DDLWizardPage<Keyspace>> createWizardSpecificPages(DDLWizardModel<Keyspace> model, CqlPreview cqlPreview, TypeParser typeParser) {
        ArrayList<DDLWizardPage<Keyspace>> pages = new ArrayList<DDLWizardPage<Keyspace>>();
        pages.add(this.page1(model, cqlPreview));
        return pages;
    }

    @Override
    protected String getPreviewTextPrefix(DDLWizardModel<Keyspace> model) {
        if (!this.isCreation()) {
            return "-- ALTER KEYSPACE statements for keyspace " + model.getCurrent().getName();
        }
        return super.getPreviewTextPrefix(model);
    }

    private KeyspaceBasicSettingsDDLWizardPage page1(DDLWizardModel<Keyspace> model, CqlPreview cqlPreview) {
        return new KeyspaceBasicSettingsDDLWizardPage(model, new DDLWizardDescription("Basic Settings", String.valueOf(this.isCreation() ? "Define" : "Modify") + " the keyspace and properties. " + "Click Next to review summary."), cqlPreview, this.getDDLAction(), this.isCreation() ? CREATE_KEYSPACE_HELP_URL : ALTER_KEYSPACE_HELP_URL);
    }
}

