/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl;

import com.datastax.devcenter.cql.generators.AlterTableStatementGenerator;
import com.datastax.devcenter.cql.generators.CreateTableStatementGenerator;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.ui.utils.StructuredSelectionUtils;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.table.TableAdvancedSettingsDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.table.TableBasicSettingsDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.table.TableCompactionSettingsDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.table.TablePrimaryKeyDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.cql.util.TypeParser;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.options.OptionsHelper;
import com.datastax.devcenter.schema.options.TableOptions;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import com.datastax.driver.core.VersionNumber;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class TableWizard
extends DDLWizard<Table> {
    private static final String CREATE_TABLE_HELP_URL = "http://www.datastax.com/documentation/cql/3.1/cql/cql_reference/create_table_r.html";
    private static final String ALTER_TABLE_HELP_URL = "http://www.datastax.com/documentation/cql/3.1/cql/cql_reference/alter_table_r.html";
    private static final String TABLE_PROPERTIES_HELP_URL = "http://www.datastax.com/documentation/cql/3.1/cql/cql_reference/tabProp.html";
    private static final String COMPACTION_SUBPROPERTIES_HELP_URL = "http://www.datastax.com/documentation/cql/3.1/cql/cql_reference/compactSubprop.html";

    @Override
    protected DDLWizardModel<Table> createModel(IWorkbench workbench, IStructuredSelection selection) {
        Table initial;
        DDLWizardModel<Table> model = new DDLWizardModel<Table>();
        model.setConnection(StructuredSelectionUtils.getActiveConnection(workbench, selection));
        Table selected = (Table)this.getSelectedSchemaElement(workbench, selection);
        switch (this.getDDLAction()) {
            default: {
                Keyspace parent = this.getActiveKeyspace(workbench, selection);
                initial = new Table(Keyspace.availableTableName((Keyspace)parent, (String)"table"));
                initial.setKeyspace(parent);
                Column col1 = new Column("id", (CqlDataType)NativeCqlDataType.UUID);
                initial.addColumn(col1);
                initial.addPartitionKey(col1);
                break;
            }
            case CLONE: {
                initial = selected.deepCopy((Object)selected.getKeyspace());
                initial.setName(Keyspace.availableTableName((Keyspace)selected.getKeyspace(), (String)(String.valueOf(selected.getName()) + "_copy")));
                break;
            }
            case EDIT: {
                Assert.isNotNull((Object)selected);
                initial = selected;
                VersionNumber versionNumber = model.getVersionNumber();
                TableOptions options = initial.getOptions();
                OptionsHelper.setDefaultValueForNullOptions((Object)options, (VersionNumber)versionNumber);
                OptionsHelper.setDefaultValueForNullOptions((Object)options.getCaching(), (VersionNumber)versionNumber);
                OptionsHelper.setDefaultValueForNullOptions((Object)options.getCompaction(), (VersionNumber)versionNumber);
                OptionsHelper.setDefaultValueForNullOptions((Object)options.getCompression(), (VersionNumber)versionNumber);
            }
        }
        model.setInitial(initial);
        model.setCurrent(initial.deepCopy((Object)initial.getKeyspace()));
        return model;
    }

    @Override
    protected void resyncModel(DDLWizardModel<Table> model, Schema schema) {
        if (!this.isCreation()) {
            Table oldInitial = model.getInitial();
            Table newInitial = schema.getKeyspace(oldInitial.getKeyspace().getName()).getTable(oldInitial.getName());
            model.setInitial(newInitial);
            for (Column currentCol : model.getCurrent().getColumns()) {
                Column initialCol = newInitial.getColumn(currentCol.getName());
                if (initialCol == null) {
                    currentCol.setOriginalName(null);
                    continue;
                }
                currentCol.setOriginalName(initialCol.getName());
            }
        }
    }

    @Override
    protected DDLWizardDescription createDescription() {
        DDLWizardDescription description = new DDLWizardDescription();
        if (this.isCreation()) {
            description.setTitle("New Table");
            description.setDescription("Create a new CQL table");
        } else {
            description.setTitle("Edit Table");
            description.setDescription("Edit the selected CQL table");
        }
        description.setImagePath("icons/table.gif");
        return description;
    }

    @Override
    protected DDLStatementGenerator<Table> createGenerator() {
        if (this.isCreation()) {
            return new CreateTableStatementGenerator();
        }
        return new AlterTableStatementGenerator();
    }

    @Override
    protected List<DDLWizardPage<Table>> createWizardSpecificPages(DDLWizardModel<Table> model, CqlPreview cqlPreview, TypeParser typeParser) {
        ArrayList<DDLWizardPage<Table>> pages = new ArrayList<DDLWizardPage<Table>>();
        pages.add(this.page1(model, cqlPreview, typeParser));
        pages.add(this.page2(model, cqlPreview));
        pages.add(this.page3(model, cqlPreview));
        pages.add(this.page4(model, cqlPreview));
        return pages;
    }

    @Override
    protected String getPreviewTextPrefix(DDLWizardModel<Table> model) {
        if (!this.isCreation()) {
            return "-- ALTER TABLE statements for table " + model.getCurrent().getName();
        }
        return super.getPreviewTextPrefix(model);
    }

    private TableBasicSettingsDDLWizardPage page1(DDLWizardModel<Table> model, CqlPreview cqlPreview, TypeParser typeParser) {
        return new TableBasicSettingsDDLWizardPage(model, new DDLWizardDescription("Basic Settings", String.valueOf(this.isCreation() ? "Define" : "Modify") + " the table's basic structure below. " + "Click Next to " + (this.isCreation() ? "fine-tune" : "review") + " the table's primary key structure."), cqlPreview, typeParser, this.getDDLAction(), this.isCreation() ? CREATE_TABLE_HELP_URL : ALTER_TABLE_HELP_URL);
    }

    private TablePrimaryKeyDDLWizardPage page2(DDLWizardModel<Table> model, CqlPreview cqlPreview) {
        return new TablePrimaryKeyDDLWizardPage(model, new DDLWizardDescription("Primary Key Settings", String.valueOf(this.isCreation() ? "Define the table's primary key structure below. " : "The primary key of a table cannot be changed. ") + "Click Next to set more advanced properties."), cqlPreview, this.getDDLAction(), this.isCreation() ? CREATE_TABLE_HELP_URL : ALTER_TABLE_HELP_URL);
    }

    private TableAdvancedSettingsDDLWizardPage page3(DDLWizardModel<Table> model, CqlPreview cqlPreview) {
        return new TableAdvancedSettingsDDLWizardPage(model, new DDLWizardDescription("Advanced Settings", String.valueOf(this.isCreation() ? "Define" : "Modify") + " advanced properties for the table. " + "Click Next to define compaction strategy."), cqlPreview, this.getDDLAction(), TABLE_PROPERTIES_HELP_URL);
    }

    private TableCompactionSettingsDDLWizardPage page4(DDLWizardModel<Table> model, CqlPreview cqlPreview) {
        return new TableCompactionSettingsDDLWizardPage(model, new DDLWizardDescription("Compaction", String.valueOf(this.isCreation() ? "Define" : "Modify") + " the compaction strategy for the table. " + "Click next to review summary."), cqlPreview, this.getDDLAction(), COMPACTION_SUBPROPERTIES_HELP_URL);
    }
}

