/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl;

import com.datastax.devcenter.cql.generators.AlterTypeStatementGenerator;
import com.datastax.devcenter.cql.generators.CreateTypeStatementGenerator;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.ui.utils.StructuredSelectionUtils;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.usertype.UserTypeBasicSettingsDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.cql.util.TypeParser;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class UserTypeWizard
extends DDLWizard<UserType> {
    private static final String CREATE_HELP_URL = "http://www.datastax.com/documentation/cql/3.1/cql/cql_reference/cqlRefcreateType.html";
    private static final String ALTER_HELP_URL = "http://www.datastax.com/documentation/cql/3.1/cql/cql_reference/cqlRefAlterType.html";

    @Override
    protected DDLWizardModel<UserType> createModel(IWorkbench workbench, IStructuredSelection selection) {
        UserType initial;
        DDLWizardModel<UserType> model = new DDLWizardModel<UserType>();
        model.setConnection(StructuredSelectionUtils.getActiveConnection(workbench, selection));
        UserType selected = (UserType)this.getSelectedSchemaElement(workbench, selection);
        switch (this.getDDLAction()) {
            default: {
                Keyspace parent = this.getActiveKeyspace(workbench, selection);
                initial = new UserType(Keyspace.availableUserTypeName((Keyspace)parent, (String)"type"));
                initial.setKeyspace(parent);
                UserTypeField col1 = new UserTypeField("field", null, (CqlDataType)NativeCqlDataType.TEXT);
                initial.addField(col1);
                break;
            }
            case CLONE: {
                initial = selected.deepCopy((Object)selected.getKeyspace());
                initial.setName(Keyspace.availableUserTypeName((Keyspace)selected.getKeyspace(), (String)(String.valueOf(selected.getName()) + "_copy")));
                break;
            }
            case EDIT: {
                Assert.isNotNull((Object)selected);
                initial = selected;
            }
        }
        model.setInitial(initial);
        model.setCurrent(initial.deepCopy((Object)initial.getKeyspace()));
        return model;
    }

    @Override
    protected void resyncModel(DDLWizardModel<UserType> model, Schema schema) {
        if (!this.isCreation()) {
            UserType oldInitial = model.getInitial();
            UserType newInitial = schema.getKeyspace(oldInitial.getKeyspace().getName()).getUserType(oldInitial.getName());
            model.setInitial(newInitial);
            for (UserTypeField currentField : model.getCurrent().getFields()) {
                UserTypeField initialField = newInitial.getField(currentField.getName());
                if (initialField == null) {
                    currentField.setOriginalName(null);
                    continue;
                }
                currentField.setOriginalName(initialField.getName());
            }
        }
    }

    @Override
    protected DDLWizardDescription createDescription() {
        DDLWizardDescription description = new DDLWizardDescription();
        if (this.isCreation()) {
            description.setTitle("New User-defined Type");
            description.setDescription("Create a new CQL user-defined type");
        } else {
            description.setTitle("Edit User-defined Type");
            description.setDescription("Edit the selected CQL user-defined type");
        }
        description.setImagePath("icons/udt.gif");
        return description;
    }

    @Override
    protected DDLStatementGenerator<UserType> createGenerator() {
        if (this.isCreation()) {
            return new CreateTypeStatementGenerator();
        }
        return new AlterTypeStatementGenerator();
    }

    @Override
    protected List<DDLWizardPage<UserType>> createWizardSpecificPages(DDLWizardModel<UserType> model, CqlPreview cqlPreview, TypeParser typeParser) {
        ArrayList<DDLWizardPage<UserType>> pages = new ArrayList<DDLWizardPage<UserType>>();
        pages.add(this.page1(model, cqlPreview, typeParser));
        return pages;
    }

    @Override
    protected String getPreviewTextPrefix(DDLWizardModel<UserType> model) {
        if (!this.isCreation()) {
            return "-- ALTER TYPE statements for user-defined type " + model.getCurrent().getName();
        }
        return super.getPreviewTextPrefix(model);
    }

    private UserTypeBasicSettingsDDLWizardPage page1(DDLWizardModel<UserType> model, CqlPreview cqlPreview, TypeParser typeParser) {
        return new UserTypeBasicSettingsDDLWizardPage(model, new DDLWizardDescription("Basic Settings", String.valueOf(this.isCreation() ? "Define" : "Modify") + " the user-defined type and properties. " + "Click Next to review summary."), cqlPreview, typeParser, this.getDDLAction(), this.isCreation() ? CREATE_HELP_URL : ALTER_HELP_URL);
    }
}

