/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.actions;

import com.datastax.devcenter.common.utils.AsyncJobHelper;
import com.datastax.devcenter.connections.ui.jobs.ConnectionJobHelper;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.generators.DDLStatementGenerationContext;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.schema.ISchemaElement;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;

public abstract class DDLWizardAction<E extends ISchemaElement>
implements IRunnableWithProgress {
    private final DDLWizardModel<E> model;
    private final DDLStatementGenerator<E> generator;
    private IStatus status = Status.CANCEL_STATUS;

    public DDLWizardAction(DDLWizardModel<E> model, DDLStatementGenerator<E> generator) {
        this.generator = generator;
        this.model = model;
    }

    public void run(final IProgressMonitor monitor) {
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Statements statements = DDLWizardAction.this.generator.generate((DDLStatementGenerationContext)DDLWizardAction.this.model);
                DDLWizardAction.this.execute(monitor, statements);
                return null;
            }
        };
        monitor.beginTask(this.getTaskName(), -1);
        this.status = this.getAsyncJobHelper().runCancellable((Callable)task, monitor);
    }

    public IStatus getStatus() {
        return this.status;
    }

    public abstract String getErrorMessage();

    protected DDLWizardModel<?> getModel() {
        return this.model;
    }

    protected AsyncJobHelper getAsyncJobHelper() {
        return new ConnectionJobHelper();
    }

    protected abstract void execute(IProgressMonitor var1, Statements var2) throws Exception;

    protected abstract String getTaskName();
}

