/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.actions;

import com.datastax.devcenter.cql.ui.handlers.ddl.DropSchemaElementJob;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.ISchemaElement;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class DropSchemaElementAction {
    private final Shell activeShell;
    private final IWorkbench workbench;
    private final StructuredSelection structuredSelection;
    private final String dropElementKeyword;

    public DropSchemaElementAction(Shell activeShell, IWorkbench workbench, StructuredSelection structuredSelection, String dropElementKeyword) {
        this.activeShell = activeShell;
        this.workbench = workbench;
        this.structuredSelection = structuredSelection;
        this.dropElementKeyword = dropElementKeyword;
    }

    public void execute() {
        if (this.confirmDrop((IStructuredSelection)this.structuredSelection)) {
            DropSchemaElementJob dropSchemaElementJob = new DropSchemaElementJob(this.workbench, this.structuredSelection, this.dropElementKeyword);
            try {
                new ProgressMonitorDialog(this.activeShell).run(true, true, (IRunnableWithProgress)dropSchemaElementJob);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (!dropSchemaElementJob.getStatus().isOK()) {
                ErrorDialog.openError((Shell)this.activeShell, (String)this.getTitle(), (String)String.format("Error dropping %s", this.dropElementKeyword), (IStatus)dropSchemaElementJob.getStatus());
            }
        }
    }

    private boolean confirmDrop(IStructuredSelection structuredSelection) {
        if (structuredSelection.size() == 1) {
            ISchemaElement firstElement = (ISchemaElement)structuredSelection.getFirstElement();
            return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)this.getTitle(), (String)String.format("Are you sure you want to drop %s %s?", this.dropElementKeyword, ModelUtil.escapeName((String)firstElement.getName())));
        }
        return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)this.getTitle(), (String)String.format("Are you sure you want to delete the selected %ss?", this.dropElementKeyword));
    }

    private String getTitle() {
        return "Drop " + this.dropElementKeyword;
    }
}

