/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.actions;

import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.actions.StatementSerializingDDLWizardAction;
import com.datastax.devcenter.schema.ISchemaElement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public abstract class EditorOpeningDDLWizardAction<E extends ISchemaElement>
extends StatementSerializingDDLWizardAction<E> {
    private Exception e;
    private final String prefix;
    private final String suffix;

    public EditorOpeningDDLWizardAction(DDLWizardModel<E> model, DDLStatementGenerator<E> generator, String prefix, String suffix) {
        super(model, generator);
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    protected void execute(IProgressMonitor monitor, Statements statements) throws Exception {
        final String contents = this.getEditorContents(statements);
        this.e = null;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    EditorOpeningDDLWizardAction.this.insertContentsInEditor(contents);
                }
                catch (Exception e) {
                    EditorOpeningDDLWizardAction.this.e = e;
                }
            }
        });
        if (this.e != null) {
            throw this.e;
        }
    }

    protected String getEditorContents(Statements statements) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (this.prefix != null && !this.prefix.isEmpty()) {
            pw.println(this.prefix);
        }
        List<String> statementsAsStrings = this.serializeStatements(statements);
        for (String stmt : statementsAsStrings) {
            pw.print(stmt);
            pw.println(";");
        }
        if (this.suffix != null && !this.suffix.isEmpty()) {
            pw.println(this.suffix);
        }
        return sw.toString();
    }

    protected abstract void insertContentsInEditor(String var1) throws Exception;
}

