/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.actions;

import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.actions.EditorOpeningDDLWizardAction;
import com.datastax.devcenter.schema.ISchemaElement;
import org.eclipse.ui.IEditorReference;

public class InsertStatementsInExistingEditorDDLWizardAction<E extends ISchemaElement>
extends EditorOpeningDDLWizardAction<E> {
    private final IEditorReference ref;

    public InsertStatementsInExistingEditorDDLWizardAction(DDLWizardModel<E> model, DDLStatementGenerator<E> generator, String prefix, String suffix, IEditorReference ref) {
        super(model, generator, prefix, suffix);
        this.ref = ref;
    }

    @Override
    protected String getTaskName() {
        return String.format("Inserting generated statement(s) into %s...", this.ref.getTitle());
    }

    @Override
    public String getErrorMessage() {
        return String.format("Could not insert the generated statement(s) into %s.", this.ref.getTitle());
    }

    @Override
    protected void insertContentsInEditor(String contents) throws Exception {
        CqlEditorPart editor = (CqlEditorPart)this.ref.getEditor(true);
        editor.setConnection(this.getModel().getConnection());
        editor.appendText(contents);
    }
}

