/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.actions;

import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.ui.CqlActivator;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.actions.EditorOpeningDDLWizardAction;
import com.datastax.devcenter.schema.ISchemaElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class InsertStatementsInNewEditorDDLWizardAction<E extends ISchemaElement>
extends EditorOpeningDDLWizardAction<E> {
    public InsertStatementsInNewEditorDDLWizardAction(DDLWizardModel<E> model, DDLStatementGenerator<E> generator, String prefix, String suffix) {
        super(model, generator, prefix, suffix);
    }

    @Override
    protected String getTaskName() {
        return "Inserting generated statement(s) into a new CQL editor...";
    }

    @Override
    public String getErrorMessage() {
        return "Could not insert the generated statement(s) into a new CQL editor.";
    }

    @Override
    protected void insertContentsInEditor(String contents) throws Exception {
        IFile file = CqlActivator.getCqlFilesScriptsManager().createNewCqlScratchPad();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        CqlEditorPart editor = (CqlEditorPart)IDE.openEditor((IWorkbenchPage)activeWorkbenchWindow.getActivePage(), (IFile)file, (boolean)true);
        editor.setConnection(this.getModel().getConnection());
        editor.appendText(contents);
    }
}

