/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.actions;

import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.ui.CqlActivator;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.actions.DDLWizardAction;
import com.datastax.devcenter.schema.ISchemaElement;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.serializer.ISerializer;

public abstract class StatementSerializingDDLWizardAction<E extends ISchemaElement>
extends DDLWizardAction<E> {
    @Inject
    protected ISerializer serializer;

    public StatementSerializingDDLWizardAction(DDLWizardModel<E> model, DDLStatementGenerator<E> generator) {
        super(model, generator);
        CqlActivator activator = CqlActivator.getDefault();
        Injector injector = activator.getInjector("com.datastax.devcenter.cql.Cql");
        injector.injectMembers((Object)this);
    }

    protected List<String> serializeStatements(Statements statements) {
        List statementsAsStrings = Lists.transform((List)statements.getStatements(), (Function)new Function<EObject, String>(){

            public String apply(EObject input) {
                return StatementSerializingDDLWizardAction.this.serializer.serialize(input);
            }
        });
        return statementsAsStrings;
    }
}

