/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.models.ConnectionList;
import com.datastax.devcenter.connections.ui.wizard.ConnectionWizard;
import com.datastax.devcenter.cql.ui.databinding.validation.ConnectionValidator;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.schema.ISchemaElement;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class ConnectionChoosingDDLWizardPage<E extends ISchemaElement>
extends DDLWizardPage<E> {
    private ComboViewer connectionComboViewer;

    public ConnectionChoosingDDLWizardPage(DDLWizardModel<E> model, DDLWizardDescription description, CqlPreview cqlPreview, DDLWizard.DDLAction ddlAction, String mainHelpUrl) {
        super(model, description, cqlPreview, ddlAction, mainHelpUrl);
    }

    @Override
    protected void preCreateControl() {
        List connections;
        super.preCreateControl();
        if (this.getModel().getConnection() == null && !(connections = ConnectionList.getInstance().getConnections()).isEmpty()) {
            this.getModel().setConnection((Connection)connections.get(0));
        }
    }

    @Override
    protected void createPageSpecificContent(Composite container, DataBindingContext ctx) {
        this.layoutConnectionCombo(container, ctx);
    }

    protected void layoutConnectionCombo(Composite container, DataBindingContext ctx) {
        new Label(container, 0).setText("Connection:");
        Combo combo = new Combo(container, 8);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = 10;
        combo.setLayoutData((Object)data);
        combo.setEnabled(this.isCreation());
        this.connectionComboViewer = new ComboViewer(combo);
        this.connectionComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.connectionComboViewer.setInput((Object)ConnectionList.getInstance().getConnections());
        this.connectionComboViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        Button button = new Button(container, 8);
        button.setText("New...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnectionChoosingDDLWizardPage.this.openNewConnectionWizard();
            }
        });
        button.setEnabled(this.isCreation());
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        IViewerObservableValue target = ViewersObservables.observeSingleSelection((Viewer)this.connectionComboViewer);
        this.bindValue(ctx, (IObservableValue)target, this.connectionObservable, new ConnectionValidator());
    }

    @Override
    protected void postCreateControl() {
        super.postCreateControl();
        this.connectionChanged(this.getModel().getConnection());
    }

    @Override
    protected void connectionChanged(Connection connection) {
        this.getCqlPreview().connectionChanged(connection);
    }

    private void openNewConnectionWizard() {
        ConnectionWizard wizard = new ConnectionWizard();
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (wizardDialog.open() == 0) {
            this.connectionComboViewer.refresh();
            this.connectionComboViewer.setSelection((ISelection)new StructuredSelection((Object)wizard.getConnection()), true);
        }
    }
}

