/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLDataBindingContext;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.schema.ISchemaElement;
import com.datastax.devcenter.schema.Schema;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class DDLWizardPage<E extends ISchemaElement>
extends WizardPage {
    private final DDLWizardModel<E> model;
    private final DDLWizard.DDLAction ddlAction;
    private final CqlPreview cqlPreview;
    private final DDLDataBindingContext ctx;
    private final String helpUrl;
    protected IObservableValue connectionObservable;

    public DDLWizardPage(DDLWizardModel<E> model, DDLWizardDescription description, CqlPreview cqlPreview, DDLWizard.DDLAction ddlAction, String helpUrl) {
        super(description.getTitle(), description.getTitle(), description.getImage());
        this.setDescription(description.getDescription());
        this.model = model;
        this.ddlAction = ddlAction;
        this.cqlPreview = cqlPreview;
        this.helpUrl = helpUrl;
        this.ctx = new DDLDataBindingContext();
    }

    public boolean isCreation() {
        return this.ddlAction == DDLWizard.DDLAction.CREATE || this.ddlAction == DDLWizard.DDLAction.CLONE;
    }

    public DDLWizard.DDLAction getDDLAction() {
        return this.ddlAction;
    }

    public DDLWizardModel<E> getModel() {
        return this.model;
    }

    protected CqlPreview getCqlPreview() {
        return this.cqlPreview;
    }

    protected Schema getDatabaseSchema() {
        CqlContext cqlContext = this.getCqlPreview().getCqlContext();
        return cqlContext.getDatabaseSchema();
    }

    public final void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite container = this.createMainContainer((Composite)sc);
        this.preCreateControl();
        this.createPageSpecificContent(container, this.ctx);
        this.installListeners();
        this.postCreateControl();
        this.layoutScrolledComposite(sc, container);
        this.setControl((Control)sc);
        this.setPageComplete(false);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.ctx);
    }

    private void layoutScrolledComposite(ScrolledComposite sc, Composite container) {
        sc.setContent((Control)container);
        sc.setMinSize(container.computeSize(-1, -1));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
    }

    public void setCqlPreviewValidationStatusProvider(ValidationStatusProvider validationStatusProvider) {
        this.ctx.setCqlPreviewValidationStatusProvider(validationStatusProvider);
    }

    protected Composite createMainContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout(this.getLayout());
        return container;
    }

    protected Layout getLayout() {
        return new GridLayout(3, false);
    }

    protected abstract void createPageSpecificContent(Composite var1, DataBindingContext var2);

    public void performHelp() {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(this.helpUrl));
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    protected void preCreateControl() {
        this.connectionObservable = BeansObservables.observeValue(this.getModel(), (String)"connection");
    }

    protected void installListeners() {
        this.connectionObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                DDLWizardPage.this.connectionChanged((Connection)event.getObservableValue().getValue());
            }
        });
    }

    protected void postCreateControl() {
    }

    protected void connectionChanged(Connection connection) {
    }

    protected void emptyCell(Composite container) {
        new Label(container, 0);
    }

    protected Label label(Composite container, String text) {
        return this.label(container, text, 0x1000000);
    }

    protected Label label(Composite container, String text, String tooltip) {
        return this.label(container, text, tooltip, 0x1000000);
    }

    protected Label label(Composite container, String text, int verticalAlignment) {
        return this.label(container, text, null, verticalAlignment);
    }

    protected Label label(Composite container, String text, String tooltip, int verticalAlignment) {
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(16384, verticalAlignment, false, false));
        label.setText(text);
        label.setToolTipText(tooltip);
        return label;
    }

    protected Button button(Composite container, String text, SelectionListener listener) {
        Button button = new Button(container, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    protected Button checkbox(Composite container, String caption, String tooltip) {
        Button checkbox = new Button(container, 32);
        GridData data = new GridData(16384, 0x1000000, false, false);
        checkbox.setLayoutData((Object)data);
        checkbox.setText(caption);
        checkbox.setToolTipText(tooltip);
        return checkbox;
    }

    protected Button radio(Composite container, String text) {
        Button button = new Button(container, 16);
        button.setText(text);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        return button;
    }

    protected Composite group(Composite container, int numOfColumns, int horizontalSpan, int horizontalAlignment, int verticalSpan, int verticalAlignment) {
        Composite group = new Composite(container, 0);
        GridLayout layout = new GridLayout(numOfColumns, true);
        group.setLayout((Layout)layout);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        GridData data = new GridData(horizontalAlignment, verticalAlignment, true, false);
        data.horizontalSpan = horizontalSpan;
        data.verticalSpan = verticalSpan;
        group.setLayoutData((Object)data);
        return group;
    }

    protected Composite horizontalGroup(Composite container, int numOfColumns, int horizontalSpan, int horizontalAlignment) {
        return this.horizontalGroup(container, numOfColumns, false, horizontalSpan, horizontalAlignment);
    }

    protected Composite horizontalGroup(Composite container, int numOfColumns, boolean makeColumnsEqualWidth, int horizontalSpan, int horizontalAlignment) {
        Composite group = new Composite(container, 0);
        GridLayout layout = new GridLayout(numOfColumns, makeColumnsEqualWidth);
        group.setLayout((Layout)layout);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData data = new GridData(horizontalAlignment, 0x1000000, true, false);
        data.horizontalSpan = horizontalSpan;
        group.setLayoutData((Object)data);
        return group;
    }

    protected Composite verticalGroup(Composite container, int verticalSpan, int verticalAlignment) {
        Composite group = new Composite(container, 0);
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData data = new GridData(4, verticalAlignment, false, false);
        data.verticalSpan = verticalSpan;
        group.setLayoutData((Object)data);
        return group;
    }

    protected Group fieldset(Composite container, String legend, int numOfColumns) {
        return this.fieldset(container, legend, numOfColumns, 1);
    }

    protected Group fieldset(Composite container, String legend, int numOfColumns, int horizontalSpan) {
        Group fieldset = new Group(container, 16);
        GridData data = new GridData(4, 128, true, false);
        data.horizontalSpan = horizontalSpan;
        fieldset.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(numOfColumns, true);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        fieldset.setLayout((Layout)layout);
        fieldset.setText(legend);
        return fieldset;
    }

    protected Composite row(Composite container, int numOfColumns) {
        return this.row(container, numOfColumns, true);
    }

    protected Composite row(Composite container, int numOfColumns, boolean makeColumnsEqualWidth) {
        Composite group = new Composite(container, 0);
        GridLayout layout = new GridLayout(numOfColumns, makeColumnsEqualWidth);
        group.setLayout((Layout)layout);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData data = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)data);
        return group;
    }

    protected Composite stack(Composite container, int horizontalSpan) {
        Composite stack = new Composite(container, 0);
        StackLayout stackLayout = new StackLayout();
        stackLayout.marginHeight = 0;
        stackLayout.marginWidth = 0;
        stack.setLayout((Layout)stackLayout);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = horizontalSpan;
        stack.setLayoutData((Object)data);
        return stack;
    }

    protected Spinner spinner(Composite container, int numOfDecimals, int min, int max, int increment) {
        Spinner spinner = new Spinner(container, 2048);
        GridData data = new GridData(16384, 128, true, false);
        if (Util.isGtk()) {
            GC gc = new GC((Drawable)spinner);
            FontMetrics fm = gc.getFontMetrics();
            int charWidth = fm.getAverageCharWidth();
            int maxNumDigits = String.valueOf(max).length() + (numOfDecimals == 0 ? 0 : 1);
            int width = spinner.computeSize((int)(maxNumDigits * charWidth), (int)-1).x;
            data.minimumWidth = (int)((double)width * 1.2);
            gc.dispose();
        }
        spinner.setLayoutData((Object)data);
        spinner.setDigits(numOfDecimals);
        spinner.setMinimum(min);
        spinner.setMaximum(max);
        spinner.setIncrement(increment);
        return spinner;
    }

    protected void dummySpinner(Composite container) {
        new Spinner(container, 0).setVisible(false);
    }

    protected void separator(Composite container) {
        Label separator = new Label(container, 258);
        GridData data = new GridData(4, 0x1000000, true, false);
        GridLayout layout = (GridLayout)this.getLayout();
        data.horizontalSpan = layout.numColumns;
        separator.setLayoutData((Object)data);
    }

    protected Binding bindValue(DataBindingContext ctx, IObservableValue target, IObservableValue model) {
        return this.bindValue(ctx, target, model, null);
    }

    protected Binding bindValue(DataBindingContext ctx, IObservableValue target, IObservableValue model, IValidator beforeSetValidator) {
        return this.bindValue(ctx, target, model, UpdateValueStrategy.POLICY_UPDATE, UpdateValueStrategy.POLICY_UPDATE, beforeSetValidator, null, null);
    }

    protected Binding bindValue(DataBindingContext ctx, IObservableValue target, IObservableValue model, int targetToModelUpdatePolicy, int modelToTargetUpdatePolicy) {
        return this.bindValue(ctx, target, model, targetToModelUpdatePolicy, modelToTargetUpdatePolicy, null, null, null);
    }

    protected Binding bindValue(DataBindingContext ctx, IObservableValue target, IObservableValue model, int targetToModelUpdatePolicy, int modelToTargetUpdatePolicy, IConverter targetToModelConverter, IConverter modelToTargetConverter) {
        return this.bindValue(ctx, target, model, targetToModelUpdatePolicy, modelToTargetUpdatePolicy, null, targetToModelConverter, modelToTargetConverter);
    }

    protected Binding bindValue(DataBindingContext ctx, IObservableValue target, IObservableValue model, int targetToModelUpdatePolicy, int modelToTargetUpdatePolicy, IValidator beforeSetValidator, IConverter targetToModelConverter, IConverter modelToTargetConverter) {
        UpdateValueStrategy targetToModel = new UpdateValueStrategy(targetToModelUpdatePolicy);
        targetToModel.setBeforeSetValidator(beforeSetValidator);
        targetToModel.setConverter(targetToModelConverter);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy(modelToTargetUpdatePolicy);
        modelToTarget.setConverter(modelToTargetConverter);
        Binding bindValue = ctx.bindValue(target, model, targetToModel, modelToTarget);
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
        return bindValue;
    }
}

