/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages;

import com.datastax.devcenter.cql.ui.databinding.binding.NullableGroup;
import com.datastax.devcenter.cql.ui.databinding.binding.NullableResettableBinding;
import com.datastax.devcenter.cql.ui.databinding.binding.ResettableGroup;
import com.datastax.devcenter.cql.ui.databinding.observable.GetOptionDefaultValueByVersion;
import com.datastax.devcenter.cql.ui.databinding.observable.IsOptionValidForVersion;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.schema.ISchemaElement;
import com.datastax.devcenter.schema.Table;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public class DDLWizardPageOptionsManager<E extends ISchemaElement> {
    protected IObservableValue versionNumberObservable;
    protected final List<NullableResettableBinding> bindings = new ArrayList<NullableResettableBinding>();
    protected final DDLWizardPage<E> ddlWizardPage;

    public DDLWizardPageOptionsManager(DDLWizardPage<E> ddlWizardPage) {
        this.ddlWizardPage = ddlWizardPage;
    }

    public void preCreateControl() {
        this.versionNumberObservable = BeansObservables.observeValue(this.ddlWizardPage.getModel(), (String)"versionNumber");
    }

    public void installListeners() {
        this.versionNumberObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                DDLWizardPageOptionsManager.this.resetNullsToDefault();
            }
        });
    }

    public void layoutLinkToDocs(Composite container, int horizontalSpan) {
        Link link = new Link(container, 0);
        link.setText("See more details about " + this.ddlWizardPage.getModel().getCurrent().getClass().getSimpleName().toLowerCase() + " properties and their default values <a href=\"" + this.ddlWizardPage.getHelpUrl() + "\">here</a>.");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDLWizardPageOptionsManager.this.ddlWizardPage.performHelp();
            }
        });
        link.setLayoutData((Object)new GridData(4, 0x1000000, false, false, horizontalSpan, 1));
    }

    public void layoutResetLink(Composite container, int horizontalSpan) {
        Link link = new Link(container, 0);
        if (this.ddlWizardPage.isCreation()) {
            link.setText("Reset properties above to their <a href=\"default\">default</a> values.");
        } else {
            link.setText("Reset properties above to their <a href=\"default\">default</a> or <a href=\"initial\">initial</a> values.");
        }
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("default".equals(e.text)) {
                    DDLWizardPageOptionsManager.this.resetToDefault();
                } else if ("initial".equals(e.text)) {
                    DDLWizardPageOptionsManager.this.resetToInitial();
                }
            }
        });
        link.setLayoutData((Object)new GridData(4, 0x1000000, false, false, horizontalSpan, 1));
    }

    public ResettableGroup newResettableGroup(String property) {
        IObservableValue currentValue = BeansObservables.observeValue(this.ddlWizardPage.getModel().getCurrent(), (String)property);
        IObservableValue initialValue = BeansObservables.observeValue(this.ddlWizardPage.getModel().getInitial(), (String)property);
        GetOptionDefaultValueByVersion defaultValue = new GetOptionDefaultValueByVersion(this.ddlWizardPage.getModel().getCurrent(), property, this.versionNumberObservable);
        return new ResettableGroup(currentValue, initialValue, (IObservableValue)defaultValue);
    }

    public NullableGroup newNullableGroup(OptionToggle option, Widget widget) {
        return new NullableGroup(option.getStatus(), (IObservableValue)WidgetProperties.selection().observe(widget), (IObservableValue)WidgetProperties.enabled().observe(widget));
    }

    public OptionToggle option(Composite container, String caption, String tooltip) {
        if (this.ddlWizardPage.isCreation()) {
            Button checkbox = this.ddlWizardPage.checkbox(container, caption, tooltip);
            return new CheckboxOptionToggle(checkbox);
        }
        return this.optionAlwaysOn(container, caption, tooltip);
    }

    public OptionToggle optionAlwaysOn(Composite container, String caption, String tooltip) {
        Label label = this.ddlWizardPage.label(container, caption, tooltip);
        return new LabelOptionToggle(label);
    }

    public void bindOptionValidityToRowVisibility(final Composite row, String property) {
        final IObservableValue valid = this.getOptionValidityObservable(property);
        valid.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                DDLWizardPageOptionsManager.this.updateOptionVisibility(row, valid);
            }
        });
        this.updateOptionVisibility(row, valid);
    }

    public void bindOptionValidityToRowVisibilityInStack(final Composite row, String property, final Composite stack, final StackLayout stackLayout) {
        final IObservableValue valid = this.getOptionValidityObservable(property);
        valid.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                DDLWizardPageOptionsManager.this.updateOptionVisibilityInStack(row, valid, stack, stackLayout);
            }
        });
        this.updateOptionVisibilityInStack(row, valid, stack, stackLayout);
    }

    protected IObservableValue getOptionValidityObservable(String property) {
        IsOptionValidForVersion isValidForVersion = new IsOptionValidForVersion(Table.class, property, this.versionNumberObservable);
        return isValidForVersion;
    }

    protected void updateOptionVisibility(Composite row, IObservableValue valid) {
        GridData data = (GridData)row.getLayoutData();
        data.exclude = (Boolean)valid.getValue() == false;
        row.setVisible(!data.exclude);
        row.getParent().getParent().layout(true);
    }

    protected void updateOptionVisibilityInStack(Composite row, IObservableValue valid, Composite stack, StackLayout stackLayout) {
        boolean reveal = (Boolean)valid.getValue();
        if (reveal) {
            stackLayout.topControl = row;
            stack.layout();
        }
    }

    public void addBinding(NullableResettableBinding binding) {
        this.bindings.add(binding);
    }

    protected void updateModelToTarget() {
        for (NullableResettableBinding binding : this.bindings) {
            binding.updateModelToTarget();
            binding.updateTarget();
        }
    }

    protected void updateTargetToModel() {
        for (NullableResettableBinding binding : this.bindings) {
            binding.updateTargetToModel();
        }
    }

    protected void resetToDefault() {
        for (NullableResettableBinding binding : this.bindings) {
            binding.resetToDefault();
        }
    }

    protected void resetToInitial() {
        for (NullableResettableBinding binding : this.bindings) {
            binding.resetToInitial();
        }
    }

    public void resetNullsToDefault() {
        for (NullableResettableBinding binding : this.bindings) {
            if (((ResettableGroup)binding.getModel()).getCurrentValue().getValue() != null) continue;
            binding.resetToDefault();
        }
    }

    public static class CheckboxOptionToggle
    extends OptionToggleBase {
        public CheckboxOptionToggle(Button checkbox) {
            super((Widget)checkbox, (IObservableValue)WidgetProperties.selection().observe((Widget)checkbox), (IObservableValue)WidgetProperties.enabled().observe((Widget)checkbox));
        }
    }

    public static class LabelOptionToggle
    extends OptionToggleBase {
        public LabelOptionToggle(Label label) {
            super((Widget)label, (IObservableValue)new WritableValue((Object)Boolean.TRUE, Boolean.TYPE), (IObservableValue)WidgetProperties.enabled().observe((Widget)label));
        }
    }

    public static interface OptionToggle {
        public Widget getWidget();

        public IObservableValue getStatus();

        public IObservableValue getEnabled();

        public void toggle(boolean var1);
    }

    public static class OptionToggleBase
    implements OptionToggle {
        private final Widget widget;
        private final IObservableValue status;
        private final IObservableValue enabled;

        public OptionToggleBase(Widget widget, IObservableValue status, IObservableValue enabled) {
            this.widget = widget;
            this.status = status;
            this.enabled = enabled;
        }

        @Override
        public Widget getWidget() {
            return this.widget;
        }

        @Override
        public IObservableValue getStatus() {
            return this.status;
        }

        @Override
        public IObservableValue getEnabled() {
            return this.enabled;
        }

        @Override
        public void toggle(boolean onOff) {
            this.status.setValue((Object)onOff);
        }
    }
}

