/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.cql.ui.databinding.validation.NotEmptyValidator;
import com.datastax.devcenter.cql.ui.providers.SchemaElementLabelProvider;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDialog;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.KeyspaceWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.ConnectionChoosingDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.IKeyspaceElement;
import com.datastax.devcenter.schema.ISchemaElement;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.driver.core.VersionNumber;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public abstract class KeyspaceChoosingDDLWizardPage<E extends IKeyspaceElement>
extends ConnectionChoosingDDLWizardPage<E> {
    protected static final ImmutableList<String> CQL_DATA_TYPES = ImmutableList.of((Object)"ascii", (Object)"bigint", (Object)"blob", (Object)"boolean", (Object)"counter", (Object)"date", (Object)"decimal", (Object)"double", (Object)"float", (Object)"inet", (Object)"int", (Object)"list<?>", (Object[])new String[]{"map<?,?>", "set<?>", "smallint", "text", "time", "timestamp", "timeuuid", "tinyint", "tuple<?>", "uuid", "varchar", "varint"});
    private final KeyspaceWritableList keyspaces = new KeyspaceWritableList();
    private ComboViewer keyspaceComboViewer;
    private IObservableValue keyspaceObservable;

    public KeyspaceChoosingDDLWizardPage(DDLWizardModel<E> model, DDLWizardDescription description, CqlPreview cqlPreview, DDLWizard.DDLAction ddlAction, String mainHelpUrl) {
        super(model, description, cqlPreview, ddlAction, mainHelpUrl);
    }

    protected ComboViewer getKeyspaceComboViewer() {
        return this.keyspaceComboViewer;
    }

    @Override
    protected void createPageSpecificContent(Composite container, DataBindingContext ctx) {
        super.createPageSpecificContent(container, ctx);
        this.separator(container);
        this.layoutKeyspaceCombo(container, ctx);
    }

    protected void layoutKeyspaceCombo(Composite container, DataBindingContext ctx) {
        new Label(container, 0).setText("Keyspace:");
        Combo combo = new Combo(container, 8);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = 10;
        combo.setLayoutData((Object)data);
        combo.setEnabled(this.isCreation());
        this.keyspaceComboViewer = new ComboViewer(combo);
        this.keyspaceComboViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.keyspaceComboViewer.setInput((Object)this.keyspaces);
        this.keyspaceComboViewer.setLabelProvider((IBaseLabelProvider)new SchemaElementLabelProvider());
        IViewerObservableValue target = ViewersObservables.observeSingleSelection((Viewer)this.keyspaceComboViewer);
        this.keyspaceObservable = BeansObservables.observeValue(this.getModel().getCurrent(), (String)"keyspace");
        NotEmptyValidator validator = new NotEmptyValidator("Keyspace cannot be empty");
        this.bindValue(ctx, (IObservableValue)target, this.keyspaceObservable, validator);
        Button button = new Button(container, 8);
        button.setText("New...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                KeyspaceChoosingDDLWizardPage.this.openNewKeyspaceWizard();
            }
        });
        button.setEnabled(this.isCreation());
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.keyspaceObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                KeyspaceChoosingDDLWizardPage.this.keyspaceChanged((Keyspace)event.getObservableValue().getValue());
            }
        });
    }

    @Override
    protected void postCreateControl() {
        super.postCreateControl();
        this.selectFirstAvailableKeyspace();
        this.keyspaceChanged(((IKeyspaceElement)this.getModel().getCurrent()).getKeyspace());
    }

    @Override
    protected void connectionChanged(Connection connection) {
        super.connectionChanged(connection);
        this.repopulateKeyspaceList();
    }

    protected void keyspaceChanged(Keyspace keyspace) {
        this.getCqlPreview().keyspaceChanged(keyspace);
    }

    private void openNewKeyspaceWizard() {
        KeyspaceWizard wizard = new KeyspaceWizard();
        wizard.init(PlatformUI.getWorkbench(), null, DDLWizard.DDLAction.CREATE, true);
        DDLWizardDialog wizardDialog = new DDLWizardDialog(this.getShell(), wizard);
        if (wizardDialog.open() == 0) {
            Keyspace newKeyspace = (Keyspace)wizard.getModel().getCurrent();
            ArrayList<Keyspace> newKeyspaces = new ArrayList<Keyspace>((Collection<Keyspace>)((Object)this.keyspaces));
            newKeyspaces.add(newKeyspace);
            Collections.sort(newKeyspaces, ISchemaElement.NAME_COMPARATOR);
            this.keyspaces.repopulate(newKeyspaces);
            this.keyspaceComboViewer.refresh();
            this.keyspaceComboViewer.setSelection((ISelection)new StructuredSelection((Object)newKeyspace), true);
            this.getCqlPreview().getCqlContext().updateDatabaseSchemaAndReset(this.getModel().getConnection());
        }
    }

    private void selectFirstAvailableKeyspace() {
        if (!this.keyspaces.isEmpty() && ((IKeyspaceElement)this.getModel().getCurrent()).getKeyspace() == null) {
            this.keyspaceObservable.setValue(this.keyspaces.iterator().next());
        }
    }

    private void repopulateKeyspaceList() {
        Schema schema = this.getDatabaseSchema();
        if (schema != null) {
            Object keyspace2;
            ArrayList<Keyspace> newKeyspaces = new ArrayList<Keyspace>();
            for (Object keyspace2 : schema.getKeyspaces()) {
                if (keyspace2.isSystemKeyspace()) continue;
                newKeyspaces.add((Keyspace)keyspace2);
            }
            Collections.sort(newKeyspaces, ISchemaElement.NAME_COMPARATOR);
            this.keyspaces.repopulate(newKeyspaces);
            if (this.keyspaceObservable.getValue() != null && this.keyspaces.contains(keyspace2 = this.keyspaceObservable.getValue())) {
                this.keyspaceComboViewer.setSelection((ISelection)new StructuredSelection(keyspace2));
            }
            if (this.keyspaceObservable.getValue() == null) {
                this.selectFirstAvailableKeyspace();
            }
        } else {
            this.keyspaces.clear();
        }
    }

    protected List<String> getVersionFilteredCqlDataTypes() {
        ArrayList<String> cqlDataTypes = new ArrayList<String>((Collection<String>)CQL_DATA_TYPES);
        VersionNumber version = this.getModel().getVersionNumber();
        if (version.compareTo(CqlConstants.CASSANDRA_2_2_0) < 0) {
            cqlDataTypes.remove("date");
            cqlDataTypes.remove("time");
            cqlDataTypes.remove("smallint");
            cqlDataTypes.remove("tinyint");
        }
        if (version.compareTo(CqlConstants.CASSANDRA_2_1_0) < 0) {
            cqlDataTypes.remove("tuple<?>");
        }
        return cqlDataTypes;
    }

    protected String[] getAppropriateCqlDataTypes() {
        List<String> filteredCqlDataTypes = this.getVersionFilteredCqlDataTypes();
        return filteredCqlDataTypes.toArray(new String[filteredCqlDataTypes.size()]);
    }

    private static class KeyspaceWritableList
    extends WritableList {
        public KeyspaceWritableList() {
            super(new ArrayList(), Keyspace.class);
        }

        public void repopulate(List<Keyspace> newList) {
            super.updateWrappedList(newList);
        }
    }
}

