/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.cql.ui.databinding.observable.And;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.schema.ISchemaElement;
import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;

public class SummaryDDLWizardPage<E extends ISchemaElement>
extends DDLWizardPage<E> {
    private IObservableValue connectionObservable;
    private Button executeStatementCheckbox;
    private Button insertStatementIntoNewEditor;
    private Button insertStatementIntoExistingEditor;
    private ComboViewer editorComboViewer;
    private Button insertStatement;
    private final boolean forceStatementExecution;

    public SummaryDDLWizardPage(DDLWizardModel<E> model, DDLWizardDescription description, CqlPreview cqlPreview, DDLWizard.DDLAction action, String mainHelpUrl, boolean forceStatementExecution) {
        super(model, description, cqlPreview, action, mainHelpUrl);
        this.forceStatementExecution = forceStatementExecution;
    }

    @Override
    protected Layout getLayout() {
        GridLayout layout = new GridLayout(1, false);
        return layout;
    }

    @Override
    protected void createPageSpecificContent(Composite container, DataBindingContext ctx) {
        this.layoutActionPrompt(container);
        this.layoutOptionsFieldset(container, ctx);
    }

    private void layoutOptionsFieldset(Composite container, DataBindingContext ctx) {
        Group fieldset = this.fieldset(container, "", 1);
        fieldset.setLayout((Layout)new GridLayout());
        this.layoutExecuteStatementOption((Composite)fieldset);
        this.layoutInsertStatementOptions((Composite)fieldset, ctx);
    }

    @Override
    protected void preCreateControl() {
        super.preCreateControl();
        this.connectionObservable = BeansObservables.observeValue(this.getModel(), (String)"connection");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.connectionObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                SummaryDDLWizardPage.this.updateExecuteStatementOptionLabel();
            }
        });
    }

    public boolean shouldExecuteStatements() {
        return this.executeStatementCheckbox.getSelection();
    }

    public boolean shouldInsertStatementsIntoNewEditor() {
        return this.insertStatement.getSelection() && this.insertStatementIntoNewEditor.getSelection();
    }

    public boolean shouldInsertStatementsIntoExistingEditor() {
        return this.insertStatement.getSelection() && this.insertStatementIntoExistingEditor.getSelection();
    }

    public IEditorReference getExistingEditorReference() {
        StructuredSelection selection = (StructuredSelection)this.editorComboViewer.getSelection();
        return (IEditorReference)selection.getFirstElement();
    }

    private void layoutActionPrompt(Composite container) {
        this.label(container, "Please review the generated statement(s) below and choose the appropriate actions to perform:");
    }

    private void layoutExecuteStatementOption(Composite container) {
        this.executeStatementCheckbox = new Button(container, 32);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.horizontalIndent = 10;
        this.executeStatementCheckbox.setLayoutData((Object)data);
        this.updateExecuteStatementOptionLabel();
        this.executeStatementCheckbox.setSelection(true);
        if (this.forceStatementExecution) {
            this.executeStatementCheckbox.setEnabled(false);
        }
    }

    private void updateExecuteStatementOptionLabel() {
        Connection connection = (Connection)this.connectionObservable.getValue();
        if (connection != null) {
            this.executeStatementCheckbox.setText("Execute the generated statement(s) using connection " + connection.getName());
            this.executeStatementCheckbox.getParent().layout();
        }
    }

    private void layoutInsertStatementOptions(Composite container, DataBindingContext ctx) {
        this.insertStatement = new Button(container, 32);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.horizontalIndent = 10;
        this.insertStatement.setLayoutData((Object)data);
        this.insertStatement.setText("Insert the generated statement(s) into:");
        this.layoutInsertStatementOptionsGroup(container, ctx);
    }

    private void layoutInsertStatementOptionsGroup(Composite container, DataBindingContext ctx) {
        Composite group = this.group(container, 2, 1, 4, 2, 128);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.horizontalIndent = 10;
        group.setLayoutData((Object)data);
        this.layoutInsertStatementIntoNewEditorOption(group);
        this.layoutInsertStatementIntoExistingEditorOption(group);
        ISWTObservableValue insertStatementSelected = WidgetProperties.selection().observe((Widget)this.insertStatement);
        ISWTObservableValue insertStatementIntoNewEditorEnabled = WidgetProperties.enabled().observe((Widget)this.insertStatementIntoNewEditor);
        this.bindValue(ctx, (IObservableValue)insertStatementSelected, (IObservableValue)insertStatementIntoNewEditorEnabled, UpdateSetStrategy.POLICY_UPDATE, UpdateSetStrategy.POLICY_NEVER).updateTargetToModel();
        if (this.editorComboViewer.getCombo().getItemCount() == 0) {
            this.insertStatementIntoExistingEditor.setEnabled(false);
        } else {
            ISWTObservableValue insertStatementIntoExistingEditorEnabled = WidgetProperties.enabled().observe((Widget)this.insertStatementIntoExistingEditor);
            And insertStatementIntoExistingEditorSelectedAndEnabled = new And((IObservableValue)insertStatementSelected, (IObservableValue)WidgetProperties.selection().observe((Widget)this.insertStatementIntoExistingEditor));
            ISWTObservableValue editorComboViewerEnabled = WidgetProperties.enabled().observe((Widget)this.editorComboViewer.getControl());
            this.bindValue(ctx, (IObservableValue)insertStatementSelected, (IObservableValue)insertStatementIntoExistingEditorEnabled, UpdateSetStrategy.POLICY_UPDATE, UpdateSetStrategy.POLICY_NEVER).updateTargetToModel();
            this.bindValue(ctx, (IObservableValue)insertStatementIntoExistingEditorSelectedAndEnabled, (IObservableValue)editorComboViewerEnabled, UpdateSetStrategy.POLICY_UPDATE, UpdateSetStrategy.POLICY_NEVER).updateTargetToModel();
        }
    }

    private void layoutInsertStatementIntoNewEditorOption(Composite container) {
        this.insertStatementIntoNewEditor = this.radio(container, "a new CQL editor");
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.horizontalIndent = 10;
        data.horizontalSpan = 2;
        this.insertStatementIntoNewEditor.setLayoutData((Object)data);
        this.insertStatementIntoNewEditor.setSelection(true);
    }

    private void layoutInsertStatementIntoExistingEditorOption(Composite container) {
        this.insertStatementIntoExistingEditor = this.radio(container, "an existing CQL editor: ");
        GridData data = new GridData(4, 0x1000000, false, false);
        data.horizontalIndent = 10;
        this.insertStatementIntoExistingEditor.setLayoutData((Object)data);
        this.layoutEditorComboViewer(container);
    }

    private void layoutEditorComboViewer(Composite container) {
        Combo combo = new Combo(container, 8);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.horizontalIndent = 10;
        data.minimumWidth = 40;
        combo.setLayoutData((Object)data);
        this.editorComboViewer = new ComboViewer(combo);
        this.editorComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        IEditorReference[] refs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        ArrayList<IEditorReference> filtered = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            if ("com.datastax.devcenter.cql.Cql".equals(ref.getId())) {
                filtered.add(ref);
            }
            ++n2;
        }
        this.editorComboViewer.setSorter(new ViewerSorter());
        this.editorComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IEditorReference)element).getTitle();
            }
        });
        this.editorComboViewer.setInput(filtered);
        if (refs.length == 0) {
            this.insertStatementIntoExistingEditor.setEnabled(false);
            combo.setEnabled(false);
        } else {
            this.editorComboViewer.setSelection((ISelection)new StructuredSelection((Object)refs[0]));
        }
    }
}

